/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.Types;

public class Quality
extends Core {
    private native boolean fbsDestroyQuality(long var1);

    private native boolean fbsQualityGetAppliedQualityResult(long var1, int var3, Integer var4, Float var5, Boolean var6);

    private native boolean fbsQualityGetImage(long var1, Long var3);

    private native boolean fbsQualityGetNumberOfAppliedQualityChecks(long var1, Integer var3);

    private native boolean fbsQualityGetOverallQualityResult(long var1, Float var3, Boolean var4);

    private native boolean fbsQualityGetRawQualityResult(long var1, int var3, Boolean var4, Float var5, Float var6, Boolean var7);

    public Quality() {
        this.internalHandle = 0L;
    }

    protected Quality(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyQuality(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    @Deprecated
    public float getOverallQualityValue() throws CustomException {
        Float qualityValue = new Float(0.0f);
        Boolean passedobj = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetOverallQualityResult(this.internalHandle, qualityValue, passedobj)) {
            this.checkError(this.internalHandle);
        }
        return qualityValue.floatValue();
    }

    public int getNumberOfAppliedQualityChecks() throws CustomException {
        Integer napplied = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetNumberOfAppliedQualityChecks(this.internalHandle, napplied)) {
            this.checkError(this.internalHandle);
        }
        return napplied;
    }

    public Types.QualityCheckType getQualityCheckType(int index) throws CustomException {
        Float qvalueF = new Float(0.0f);
        Boolean passedB = new Boolean(false);
        Integer checktypeordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetAppliedQualityResult(this.internalHandle, index, checktypeordinal, qvalueF, passedB)) {
            this.checkError(this.internalHandle);
        }
        Types.QualityCheckType type = Types.QualityCheckType.valueOf(checktypeordinal);
        return type;
    }

    public float getQualityValue(Types.QualityCheckType type) throws CustomException {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Float qvalueF = new Float(0.0f);
        Float rawQvalueB = new Float(0.0f);
        Boolean passedB = new Boolean(false);
        Boolean appliedB = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetRawQualityResult(this.internalHandle, type.getNumericValue(), appliedB, qvalueF, rawQvalueB, passedB)) {
            this.checkError(this.internalHandle);
        }
        return qvalueF.floatValue();
    }

    public float getQualityRawValue(Types.QualityCheckType type) throws CustomException {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Float qvalueF = new Float(0.0f);
        Float rawQvalueB = new Float(0.0f);
        Boolean passedB = new Boolean(false);
        Boolean appliedB = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetRawQualityResult(this.internalHandle, type.getNumericValue(), appliedB, qvalueF, rawQvalueB, passedB)) {
            this.checkError(this.internalHandle);
        }
        return rawQvalueB.floatValue();
    }

    public boolean isQualityMetricAvailable(Types.QualityCheckType type) throws CustomException {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Float qvalueF = new Float(0.0f);
        Float rawQvalueB = new Float(0.0f);
        Boolean passedB = new Boolean(false);
        Boolean appliedB = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetRawQualityResult(this.internalHandle, type.getNumericValue(), appliedB, qvalueF, rawQvalueB, passedB)) {
            this.checkError(this.internalHandle);
        }
        return appliedB;
    }

    public Image getImage() throws CustomException {
        Long imageHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsQualityGetImage(this.internalHandle, imageHande)) {
            this.checkError(this.internalHandle);
        }
        Image image = new Image(imageHande);
        return image;
    }
}

