/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Types;

public class ResultList
extends Core {
    private native long fbsCreateResultList();

    private native boolean fbsDestroyResultList(long var1);

    private native boolean fbsResultListNumberResults(long var1, Integer var3);

    private native boolean fbsResultListGetIds(long var1, int var3, Long var4, Long var5);

    private native boolean fbsResultListGetScore(long var1, int var3, int var4, Float var5);

    private native boolean fbsResultListNumberInstances(long var1, int var3, int var4, Integer var5);

    private native boolean fbsResultListGetInstance(long var1, int var3, int var4, int var5, Integer var6);

    private native boolean fbsResultListNumberSamples(long var1, int var3, int var4, int var5, Integer var6);

    private native boolean fbsResultListGetSampleId(long var1, int var3, int var4, int var5, int var6, Long var7);

    private native boolean fbsResultListGetSampleScore(long var1, int var3, int var4, int var5, long var6, Float var8);

    private native boolean fbsResultListGetAlgorithmScore(long var1, int var3, int var4, int var5, long var6, int var8, Float var9);

    private native boolean fbsResultListGetBestSampleScore(long var1, int var3, int var4, int var5, Long var6, Float var7);

    private native byte[] fbsResultListGetSID(long var1, int var3);

    public ResultList() {
        this.internalHandle = this.fbsCreateResultList();
    }

    protected ResultList(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyResultList(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public int length() throws CustomException {
        Integer numberOfScores = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListNumberResults(this.internalHandle, numberOfScores)) {
            this.checkError(this.internalHandle);
        }
        return numberOfScores;
    }

    public long getPersonId(int index) throws CustomException {
        Long outPersonId = new Long(0L);
        Long outTransactionId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetIds(this.internalHandle, index, outPersonId, outTransactionId)) {
            this.checkError(this.internalHandle);
        }
        return outPersonId;
    }

    public long getTransactionId(int index) throws CustomException {
        Long outPersonId = new Long(0L);
        Long outTransactionId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetIds(this.internalHandle, index, outPersonId, outTransactionId)) {
            this.checkError(this.internalHandle);
        }
        return outTransactionId;
    }

    public float getScore(int index, Types.Modality modality) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        Float outScore = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetScore(this.internalHandle, index, modality.getNumericValue(), outScore)) {
            this.checkError(this.internalHandle);
        }
        return outScore.floatValue();
    }

    public int getInstanceCount(int index, Types.Modality modality) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        Integer numberOfInstances = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListNumberInstances(this.internalHandle, index, modality.getNumericValue(), numberOfInstances)) {
            this.checkError(this.internalHandle);
        }
        return numberOfInstances;
    }

    public Types.Instance getInstance(int index, Types.Modality modality, int instanceIndex) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        Integer instanceordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetInstance(this.internalHandle, index, modality.getNumericValue(), instanceIndex, instanceordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.Instance instanceObj = Types.Instance.valueOf(instanceordinal);
        return instanceObj;
    }

    public int getSampleCount(int index, Types.Modality modality, Types.Instance instance) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        Integer numberOfSamples = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListNumberSamples(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), numberOfSamples)) {
            this.checkError(this.internalHandle);
        }
        return numberOfSamples;
    }

    public long getSampleId(int index, Types.Modality modality, Types.Instance instance, int sampleIndex) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        Long sampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetSampleId(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), sampleIndex, sampleId)) {
            this.checkError(this.internalHandle);
        }
        return sampleId;
    }

    public float getSampleScore(int index, Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        Float outScore = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetSampleScore(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), sampleId, outScore)) {
            this.checkError(this.internalHandle);
        }
        return outScore.floatValue();
    }

    public float getAlgorithmScore(int index, Types.Modality modality, Types.Instance instance, long sampleId, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        Float outScore = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetAlgorithmScore(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), sampleId, algorithm.getNumericValue(), outScore)) {
            this.checkError(this.internalHandle);
        }
        return outScore.floatValue();
    }

    public float getBestSampleScore(int index, Types.Modality modality, Types.Instance instance) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        Float outScore = new Float(0.0f);
        Long outsampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetBestSampleScore(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), outsampleId, outScore)) {
            this.checkError(this.internalHandle);
        }
        return outScore.floatValue();
    }

    public Long getBestSampleId(int index, Types.Modality modality, Types.Instance instance) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        Float outScore = new Float(0.0f);
        Long outsampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsResultListGetBestSampleScore(this.internalHandle, index, modality.getNumericValue(), instance.getNumericValue(), outsampleId, outScore)) {
            this.checkError(this.internalHandle);
        }
        return outsampleId;
    }

    public byte[] getSID(int index) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        byte[] data = this.fbsResultListGetSID(this.internalHandle, index);
        if (data == null) {
            this.checkError(this.internalHandle);
        }
        return data;
    }
}

