/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.Roi;
import com.l1id.sdk.foundation.Types;

public class StandardFaceImageGenerator
extends Core {
    private boolean initialized = false;

    private native long fbsCreateStandardImageCreator();

    private native boolean fbsDestroyStandardImageCreator(long var1);

    private native boolean fbsStandardImageCreatorInit(long var1, int var3, int var4);

    private native boolean fbsStandardImageCreatorSetParameter(long var1, int var3, float var4);

    private native boolean fbsStandardImageCreatorGetParameter(long var1, int var3, Float var4);

    private native boolean fbsStandardImageCreatorCreateStandardImage(long var1, long var3, long var5, long var7, long var9, int var11);

    private native boolean fbsStandardImageCreatorCalculateCropCoordinates(long var1, long var3, long var5, long var7, int var9);

    private native boolean fbsStandardImageCreatorPerformImageChecks(long var1, long var3, long var5);

    public StandardFaceImageGenerator(Types.StandardFaceImageGenerationMode stdImgMode) throws CustomException {
        this.internalHandle = this.fbsCreateStandardImageCreator();
        Types.Modality modality = Types.Modality.Face;
        if (!this.fbsStandardImageCreatorInit(this.internalHandle, modality.getNumericValue(), stdImgMode.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
        this.initialized = true;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyStandardImageCreator(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void setFullFrontalAspectRatio(float ratio) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorSetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalAspectRatio.getNumericValue(), ratio)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setFullFrontalMaxTargetWidthToEyeDistRatio(float ratio) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorSetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalMaxDestWidthToEyeDistRatio.getNumericValue(), ratio)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setFullFrontalTargetWidth(float width) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorSetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalTargetWidth.getNumericValue(), width)) {
            this.checkError(this.internalHandle);
        }
    }

    public float getFullFrontalAspectRatio() throws CustomException {
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorGetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalAspectRatio.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public float getFullFrontalMaxTargetWidthToEyeDistRatio() throws CustomException {
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorGetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalMaxDestWidthToEyeDistRatio.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public float getFullFrontalTargetWidth() throws CustomException {
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorGetParameter(this.internalHandle, StandardFaceImageGenerationParameter.FullFrontalTargetWidth.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public void createStandardImage(Image inputImage, ImageDescriptor inputImageDescriptor, Image outputImage, ImageDescriptor outputImageDescriptor, Types.StandardFaceImageType type) throws CustomException {
        if (inputImage == null) {
            throw new IllegalArgumentException("inputImage is null");
        }
        if (inputImageDescriptor == null) {
            throw new IllegalArgumentException("inputImageDescriptor is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorCreateStandardImage(this.internalHandle, inputImage.getHandle(), inputImageDescriptor.getHandle(), outputImage.getHandle(), outputImageDescriptor.getHandle(), type.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Roi calculateCropCoordinates(Image inputImage, ImageDescriptor inputImageDescriptor) throws CustomException {
        if (inputImage == null) {
            throw new IllegalArgumentException("inputImage is null");
        }
        if (inputImageDescriptor == null) {
            throw new IllegalArgumentException("inputImageDescriptor is null");
        }
        Roi roi = new Roi();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Types.StandardFaceImageType type = Types.StandardFaceImageType.FaceFullFrontal;
        if (!this.fbsStandardImageCreatorCalculateCropCoordinates(this.internalHandle, inputImage.getHandle(), inputImageDescriptor.getHandle(), roi.getHandle(), type.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
        return roi;
    }

    public void performImageChecks(Image inputImage, ImageDescriptor inputImageDescriptor) throws CustomException {
        if (inputImage == null) {
            throw new IllegalArgumentException("inputImage is null");
        }
        if (inputImageDescriptor == null) {
            throw new IllegalArgumentException("inputImageDescriptor is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsStandardImageCreatorPerformImageChecks(this.internalHandle, inputImage.getHandle(), inputImageDescriptor.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    private static enum StandardFaceImageGenerationParameter {
        FullFrontalAspectRatio(1),
        FullFrontalMaxDestWidthToEyeDistRatio(2),
        FullFrontalTargetWidth(3);

        protected final int value;

        private StandardFaceImageGenerationParameter(int valA) {
            this.value = valA;
        }

        public int getNumericValue() {
            return this.value;
        }

        public static StandardFaceImageGenerationParameter valueOf(int valueA) {
            for (StandardFaceImageGenerationParameter m : StandardFaceImageGenerationParameter.values()) {
                if (m.value != valueA) continue;
                return m;
            }
            throw new IllegalArgumentException("No matching constant for " + valueA);
        }
    }
}

