/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.IdRecord;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageCollection;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.ImageDescriptorList;
import com.l1id.sdk.foundation.Types;

public class TemplateGenerator
extends Core {
    private native long fbsCreateTemplateCreator();

    private native boolean fbsDestroyTemplateCreator(long var1);

    private native boolean fbsTemplateCreatorInit(long var1, int var3, int var4, int[] var5, int var6, int var7);

    private native boolean fbsTemplateCreatorInit(long var1, String var3);

    private native boolean fbsTemplateCreatorCreateTemplates(long var1, long var3, int var5, long var6, long var8, long var10);

    private native boolean fbsTemplateCreatorValidateIdRecord(long var1, long var3);

    private native boolean fbsTemplateCreatorFindLandmarks(long var1, long var3, long var5);

    private native boolean fbsTemplateCreatorConvertFingerPalmTemplate(long var1, long var3, int var5, long var6, long var8, int var10, Long var11);

    private native boolean fbsTemplateCreatorFindMultipleFaces(long var1, long var3, long var5);

    private native boolean fbsTemplateCreatorExportToVersion(long var1, long var3, int var5, Long var6);

    public TemplateGenerator(Types.Modality modality, Types.TemplateCreationMode mode, Types.Algorithm[] algorithms, int numberOfThreads) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (algorithms == null) {
            throw new IllegalArgumentException("algorithms is null");
        }
        this.internalHandle = this.fbsCreateTemplateCreator();
        int[] algorithmsToInitializeordinal = new int[algorithms.length];
        for (int i = 0; i < algorithms.length; ++i) {
            Types.Algorithm algo = algorithms[i];
            algorithmsToInitializeordinal[i] = algo.getNumericValue();
        }
        int numberOfAlgorithms = algorithmsToInitializeordinal.length;
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorInit(this.internalHandle, modality.getNumericValue(), mode.getNumericValue(), algorithmsToInitializeordinal, numberOfAlgorithms, numberOfThreads)) {
            this.checkError(this.internalHandle);
        }
    }

    public TemplateGenerator(String id) throws CustomException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id is null or empty");
        }
        this.internalHandle = this.fbsCreateTemplateCreator();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorInit(this.internalHandle, id)) {
            this.checkError(this.internalHandle);
        }
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyTemplateCreator(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public IdRecord createTemplates(ImageCollection imageCollection, Types.TemplateCreationType templateCreationType, long personId, long transactionId) throws CustomException {
        if (imageCollection == null) {
            throw new IllegalArgumentException("imageCollection is null");
        }
        if (templateCreationType == null) {
            throw new IllegalArgumentException("templateCreationType is null");
        }
        IdRecord rec = new IdRecord();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorCreateTemplates(this.internalHandle, imageCollection.getHandle(), templateCreationType.getNumericValue(), rec.getHandle(), personId, transactionId)) {
            this.checkError(this.internalHandle);
        }
        return rec;
    }

    public void findLandmarks(Image image, ImageDescriptor imageDescriptor) throws CustomException {
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        if (imageDescriptor == null) {
            throw new IllegalArgumentException("imageDescriptor is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorFindLandmarks(this.internalHandle, image.getHandle(), imageDescriptor.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public Blob convertFingerPalmTemplate(IdRecord idRecord, Types.Instance instance, long sampleId, Types.StandardTemplateType standardTemplateType) throws CustomException {
        if (idRecord == null) {
            throw new IllegalArgumentException("isRecord is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (standardTemplateType == null) {
            throw new IllegalArgumentException("standardTemplateType is null");
        }
        long sampleIdHi = 0L;
        Long blobHandle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorConvertFingerPalmTemplate(this.internalHandle, idRecord.getHandle(), instance.getNumericValue(), sampleId, sampleIdHi, standardTemplateType.getNumericValue(), blobHandle)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHandle);
        return blob;
    }

    public ImageDescriptorList findMultipleFaces(Image image) throws CustomException {
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        ImageDescriptorList list = new ImageDescriptorList();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateCreatorFindMultipleFaces(this.internalHandle, image.getHandle(), list.getHandle())) {
            this.checkError(this.internalHandle);
        }
        return list;
    }

    public Blob exportToVersion(Blob sampleIn, Types.FndVersion version) throws CustomException {
        if (sampleIn == null) {
            throw new IllegalArgumentException("sampleIn is null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long blobHandle = new Long(0L);
        if (!this.fbsTemplateCreatorExportToVersion(this.internalHandle, sampleIn.getHandle(), version.getNumericValue(), blobHandle)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHandle);
        return blob;
    }
}

