/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.IdRecord;
import com.l1id.sdk.foundation.ProbeDescriptor;
import com.l1id.sdk.foundation.ResultList;
import com.l1id.sdk.foundation.TemplateMatcherConfiguration;

public class TemplateMatcher
extends Core {
    private native long fbsCreateTemplateMatcher(int var1);

    private native boolean fbsDestroyTemplateMatcher(long var1);

    private native boolean fbsTemplateMatcherInit(long var1, String var3, String var4, boolean var5);

    private native boolean fbsTemplateMatcherIdentify(long var1, long var3, long var5, long var7, long var9);

    private native boolean fbsTemplateMatcherGetConfiguration(long var1, Long var3);

    private native boolean fbsTemplateMatcherAdd(long var1, long var3, int[] var5);

    private native boolean fbsTemplateMatcherValidateIdRecord(long var1, long var3);

    private native boolean fbsTemplateMatcherGetNumberOfIdRecords(long var1, Integer var3);

    private native boolean fbsTemplateMatcherGetNumberOfPersons(long var1, Integer var3);

    private native boolean fbsTemplateMatcherGetIdRecord(long var1, Long var3, long var4);

    private native boolean fbsTemplateMatcherDeleteIdRecord(long var1, long var3);

    private native boolean fbsTemplateMatcherDeleteAllIdRecords(long var1);

    private native boolean fbsTemplateMatcherGetMaxTransactionID(long var1, Long var3);

    private native boolean fbsTemplateMatcherAddMerge(long var1, long var3, int[] var5);

    private native boolean fbsTemplateMatcherGetMasterChecksum(long var1, Long var3);

    private native boolean fbsTemplateMatcherGenerateMatcherStatus(long var1, int var3, Long var4);

    private native boolean fbsTemplateMatcherGetQueryLanguageSize(long var1, Integer var3);

    private native boolean fbsTemplateMatcherGetTransactionIDFromSID(long var1, byte[] var3, int var4, Long var5);

    private native boolean fbsTemplateMatcherGetSIDSize(long var1, Integer var3);

    private native byte[] fbsTemplateMatcherGetSIDFromTransactionID(long var1, long var3, Integer var5);

    private native boolean fbsTemplateMatcherAddMatchingPipeline(long var1, String var3);

    public TemplateMatcher(String storageId, String templateFolder, boolean recover) throws CustomException {
        if (storageId == null || storageId.isEmpty()) {
            throw new IllegalArgumentException("storageId is null or empty");
        }
        if (templateFolder == null) {
            throw new IllegalArgumentException("templateFolder is null or empty");
        }
        int nThreads = 1;
        this.internalHandle = this.fbsCreateTemplateMatcher(nThreads);
        this.initialize(storageId, templateFolder, recover);
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyTemplateMatcher(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    private void initialize(String storageId, String templateFolder, boolean recover) throws CustomException {
        if (storageId == null || storageId.isEmpty()) {
            throw new IllegalArgumentException("storageId is null or empty");
        }
        if (templateFolder == null) {
            throw new IllegalArgumentException("templateFolder is null or empty");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("Handle is NULL");
        }
        if (!this.fbsTemplateMatcherInit(this.internalHandle, storageId, templateFolder, recover)) {
            this.checkError(this.internalHandle);
        }
    }

    public ResultList identify(IdRecord probeRecord, ProbeDescriptor probeDescriptor) throws CustomException {
        if (probeRecord == null) {
            throw new IllegalArgumentException("probeRecord is null");
        }
        if (probeDescriptor == null) {
            throw new IllegalArgumentException("probeDescriptor is null");
        }
        long threadIndexA = 0L;
        ResultList list = new ResultList();
        Long listHandle = new Long(list.getHandle());
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherIdentify(this.internalHandle, probeRecord.getHandle(), probeDescriptor.getHandle(), listHandle, threadIndexA)) {
            this.checkError(this.internalHandle);
        }
        return list;
    }

    public TemplateMatcherConfiguration getConfiguration() throws CustomException {
        Long handle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetConfiguration(this.internalHandle, handle)) {
            this.checkError(this.internalHandle);
        }
        TemplateMatcherConfiguration config = new TemplateMatcherConfiguration(handle);
        return config;
    }

    public void add(IdRecord idRecord) throws CustomException {
        if (idRecord == null) {
            throw new IllegalArgumentException("idRecord is null");
        }
        int[] queryattributes = new int[]{};
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherAdd(this.internalHandle, idRecord.getHandle(), queryattributes)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getNumberOfIdRecords() throws CustomException {
        Integer size = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetNumberOfIdRecords(this.internalHandle, size)) {
            this.checkError(this.internalHandle);
        }
        return size;
    }

    public int getNumberOfPersons() throws CustomException {
        Integer personCount = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetNumberOfPersons(this.internalHandle, personCount)) {
            this.checkError(this.internalHandle);
        }
        return personCount;
    }

    public IdRecord getIdRecord(long transactionID) throws CustomException {
        Long galleryRecordHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetIdRecord(this.internalHandle, galleryRecordHande, transactionID)) {
            this.checkError(this.internalHandle);
        }
        IdRecord record = new IdRecord(galleryRecordHande);
        return record;
    }

    public void deleteIdRecord(long transactionID) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherDeleteIdRecord(this.internalHandle, transactionID)) {
            this.checkError(this.internalHandle);
        }
    }

    public void deleteAllIdRecords() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherDeleteAllIdRecords(this.internalHandle)) {
            this.checkError(this.internalHandle);
        }
    }

    public long getMaxTransactionId() throws CustomException {
        Long tranId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetMaxTransactionID(this.internalHandle, tranId)) {
            this.checkError(this.internalHandle);
        }
        return tranId;
    }

    public void addMerge(IdRecord idRecord) throws CustomException {
        if (idRecord == null) {
            throw new IllegalArgumentException("idRecord");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        int[] queryLanguageAttributes = new int[]{};
        if (!this.fbsTemplateMatcherAddMerge(this.internalHandle, idRecord.getHandle(), queryLanguageAttributes)) {
            this.checkError(this.internalHandle);
        }
    }

    public long getMasterChecksum() throws CustomException {
        Long masterChecksum = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetMasterChecksum(this.internalHandle, masterChecksum)) {
            this.checkError(this.internalHandle);
        }
        return masterChecksum;
    }

    public String generateMatcherStatus(int intensity) throws CustomException {
        Long blobHandle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGenerateMatcherStatus(this.internalHandle, intensity, blobHandle)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHandle);
        return new String(blob.getData());
    }

    public long getTransactionIDFromSID(byte[] SID) throws CustomException {
        if (SID == null) {
            throw new IllegalArgumentException("SID is null");
        }
        Long transactionID = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetTransactionIDFromSID(this.internalHandle, SID, SID.length, transactionID)) {
            this.checkError(this.internalHandle);
        }
        return transactionID;
    }

    public int getSIDSize() throws CustomException {
        Integer datasize = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherGetSIDSize(this.internalHandle, datasize)) {
            this.checkError(this.internalHandle);
        }
        return datasize;
    }

    public byte[] getSIDFromTransactionID(long transactionID) throws CustomException {
        Integer datasize = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        byte[] data = this.fbsTemplateMatcherGetSIDFromTransactionID(this.internalHandle, transactionID, datasize);
        if (data == null) {
            this.checkError(this.internalHandle);
        }
        return data;
    }

    public void addMatchingPipeline(String pipelineId) throws CustomException {
        if (pipelineId == null || pipelineId.isEmpty()) {
            throw new IllegalArgumentException("pipelineId is null or empty");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherAddMatchingPipeline(this.internalHandle, pipelineId)) {
            this.checkError(this.internalHandle);
        }
    }
}

