/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Types;

public class TemplateMatcherConfiguration
extends Core {
    private native boolean fbsDestroyFbsTemplateMatcherConfigurationHandle(long var1);

    private native boolean fbsTemplateMatcherConfigurationGetNumberOfPasses(long var1, Integer var3);

    private native boolean fbsTemplateMatcherConfigurationGetModalityInstanceAlgorithm(long var1, int var3, Integer var4, Integer var5, Integer var6);

    private native boolean fbsTemplateMatcherConfigurationSetParameter(long var1, int var3, int var4, int var5, int var6, float var7);

    private native boolean fbsTemplateMatcherConfigurationGetParameter(long var1, int var3, int var4, int var5, int var6, Float var7);

    TemplateMatcherConfiguration() {
    }

    protected TemplateMatcherConfiguration(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyFbsTemplateMatcherConfigurationHandle(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public int getNumberOfPasses() throws CustomException {
        Integer nstages = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetNumberOfPasses(this.internalHandle, nstages)) {
            this.checkError(this.internalHandle);
        }
        return nstages;
    }

    public Types.Modality getModality(int passIndex) throws CustomException {
        Integer returnModality = new Integer(0);
        Integer returnInstance = new Integer(0);
        Integer returnAlgorithm = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetModalityInstanceAlgorithm(this.internalHandle, passIndex, returnModality, returnInstance, returnAlgorithm)) {
            this.checkError(this.internalHandle);
        }
        Types.Modality modality = Types.Modality.valueOf(returnModality);
        return modality;
    }

    public Types.Instance getInstance(int passIndex) throws CustomException {
        Integer returnModality = new Integer(0);
        Integer returnInstance = new Integer(0);
        Integer returnAlgorithm = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetModalityInstanceAlgorithm(this.internalHandle, passIndex, returnModality, returnInstance, returnAlgorithm)) {
            this.checkError(this.internalHandle);
        }
        Types.Instance instance = Types.Instance.valueOf(returnInstance);
        return instance;
    }

    public Types.Algorithm getAlgorithm(int passIndex) throws CustomException {
        Integer returnModality = new Integer(0);
        Integer returnInstance = new Integer(0);
        Integer returnAlgorithm = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetModalityInstanceAlgorithm(this.internalHandle, passIndex, returnModality, returnInstance, returnAlgorithm)) {
            this.checkError(this.internalHandle);
        }
        Types.Algorithm algo = Types.Algorithm.valueOf(returnAlgorithm);
        return algo;
    }

    public void setGlobalPercentageResultLength(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm, float relResultLength) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationSetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), MatchingParameter.ResultLengthGlobalPercentageC.getNumericValue(), relResultLength)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setLocalPercentageResultLength(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm, float relResultLength) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationSetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), MatchingParameter.ResultLengthLocalPercentageC.getNumericValue(), relResultLength)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setResultLengthMax(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm, float maxResultLength) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationSetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), MatchingParameter.ResultLengthMaxC.getNumericValue(), maxResultLength)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setResultLengthMin(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm, float minResultLength) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationSetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), MatchingParameter.ResultLengthMinC.getNumericValue(), minResultLength)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setNormalization(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm, boolean useNormalization) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        float valueL = 0.0f;
        if (useNormalization) {
            valueL = 1.0f;
        }
        if (!this.fbsTemplateMatcherConfigurationSetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), MatchingParameter.UseNormalizationC.getNumericValue(), valueL)) {
            this.checkError(this.internalHandle);
        }
    }

    public float getGlobalPercentageResultLength(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        MatchingParameter parameter = MatchingParameter.ResultLengthGlobalPercentageC;
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), parameter.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public float getLocalPercentageResultLength(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        MatchingParameter parameter = MatchingParameter.ResultLengthLocalPercentageC;
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), parameter.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public float getResultLengthMax(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        MatchingParameter parameter = MatchingParameter.ResultLengthMaxC;
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), parameter.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public float getResultLengthMin(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        MatchingParameter parameter = MatchingParameter.ResultLengthMinC;
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), parameter.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return value.floatValue();
    }

    public boolean getNormalization(Types.Modality modality, Types.Instance instance, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        MatchingParameter parameter = MatchingParameter.UseNormalizationC;
        Float value = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsTemplateMatcherConfigurationGetParameter(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), algorithm.getNumericValue(), parameter.getNumericValue(), value)) {
            this.checkError(this.internalHandle);
        }
        return (double)value.floatValue() >= 0.001;
    }

    static enum MatchingParameter {
        ResultLengthMinC(0),
        ResultLengthMaxC(1),
        ResultLengthLocalPercentageC(2),
        ResultLengthGlobalPercentageC(3),
        UseNormalizationC(4);

        protected final int valueM;

        private MatchingParameter(int valueA) {
            this.valueM = valueA;
        }

        public int getNumericValue() {
            return this.valueM;
        }

        public static MatchingParameter valueOf(int valueA) {
            for (MatchingParameter type : MatchingParameter.values()) {
                if (type.valueM != valueA) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching constant for : " + valueA);
        }
    }
}

