/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.IdRecord;
import com.l1id.sdk.foundation.ResultList;
import com.l1id.sdk.foundation.TemplateMatcherConfiguration;

public class Verifier
extends Core {
    private native long fbsCreateVerifier();

    private native boolean fbsDestroyVerifier(long var1);

    private native boolean fbsVerifierInit(long var1, String var3);

    private native boolean fbsVerifierVerify(long var1, long var3, long var5, long var7, long var9);

    private native boolean fbsVerifierGetConfiguration(long var1, Long var3);

    public Verifier(String pipelineId) throws CustomException {
        if (pipelineId == null || pipelineId.isEmpty()) {
            throw new IllegalArgumentException("pipelineId is null or empty");
        }
        this.internalHandle = this.fbsCreateVerifier();
        this.initialize(pipelineId);
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyVerifier(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    private void initialize(String pipelineId) throws CustomException {
        if (pipelineId == null || pipelineId.isEmpty()) {
            throw new IllegalArgumentException("pipelineId is null or empty");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsVerifierInit(this.internalHandle, pipelineId)) {
            this.checkError(this.internalHandle);
        }
    }

    public ResultList verify(IdRecord probe, IdRecord gallery) throws CustomException {
        if (probe == null) {
            throw new IllegalArgumentException("probe is null");
        }
        if (gallery == null) {
            throw new IllegalArgumentException("gallery is null");
        }
        int threadIndex = 0;
        ResultList list = new ResultList();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsVerifierVerify(this.internalHandle, probe.getHandle(), gallery.getHandle(), list.getHandle(), threadIndex)) {
            this.checkError(this.internalHandle);
        }
        return list;
    }

    public TemplateMatcherConfiguration getConfiguration() throws CustomException {
        Long tempMatchConfHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsVerifierGetConfiguration(this.internalHandle, tempMatchConfHande)) {
            this.checkError(this.internalHandle);
        }
        TemplateMatcherConfiguration tempMatchConf = new TemplateMatcherConfiguration(tempMatchConfHande);
        return tempMatchConf;
    }
}

