/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Types;

public class WriteImageDescriptor
extends Core {
    private native long fbsCreateWriteImageDescriptor();

    private native boolean fbsDestroyWriteImageDescriptor(long var1);

    private native boolean fbsWriteImageDescriptorSetCompressionQuality(long var1, int var3, int var4);

    private native boolean fbsWriteImageDescriptorSetCompressionRatio(long var1, int var3, float var4);

    private native boolean fbsWriteImageDescriptorSetPngCompressionLevel(long var1, int var3);

    private native boolean fbsWriteImageDescriptorSetCompressionFraction(long var1, int var3, float var4);

    public WriteImageDescriptor() {
        this.internalHandle = this.fbsCreateWriteImageDescriptor();
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyWriteImageDescriptor(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void setJpegCompressionQuality(int quality) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsWriteImageDescriptorSetCompressionQuality(this.internalHandle, Types.ImageFormat.Jpeg.getNumericValue(), quality)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setJpeg2000CompressionQuality(int quality) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsWriteImageDescriptorSetCompressionQuality(this.internalHandle, Types.ImageFormat.Jpeg2000.getNumericValue(), quality)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setWsqCompressionRatio(float ratio) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsWriteImageDescriptorSetCompressionRatio(this.internalHandle, Types.ImageFormat.Wsq.getNumericValue(), ratio)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setPngCompressionLevel(int compressionLevel) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsWriteImageDescriptorSetPngCompressionLevel(this.internalHandle, compressionLevel)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setJpeg2000CompressionFraction(float fraction) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsWriteImageDescriptorSetCompressionFraction(this.internalHandle, Types.ImageFormat.Jpeg2000.getNumericValue(), fraction)) {
            this.checkError(this.internalHandle);
        }
    }
}

