/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.appointment.service.impl;

import com.safenetinc.luna.provider.LunaProvider;
import in.gov.uidai.appointment.constants.ISignErrorContants;
import in.gov.uidai.appointment.exception.SignatureException;
import in.gov.uidai.appointment.service.SignatureService;
import in.gov.uidai.appointment.util.EnviromentProperty;
import in.gov.uidai.appointment.util.Luna5HSMHelper;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.stereotype.Component;

@Component
public class Luna5HSMSignatureServiceImpl
implements SignatureService,
ISignErrorContants {
    private static final String LUNA5_PROVIDER = "LunaProvider";
    private static final String LUNA_KEY_STORE_TYPE = "Luna";
    private static Log LOGGER = LogFactory.getLog(Luna5HSMSignatureServiceImpl.class);
    private PrivateKey privateKey = null;
    private KeyStore lunaStore = null;
    private X509Certificate x509Cert = null;

    @Override
    public byte[] signForQRCode(byte[] originalMessage, EnviromentProperty env) throws SignatureException {
        byte[] signedByteArray = null;
        try {
            this.getPrivateKeyFromHSM(Integer.parseInt(env.getHsmPartition()), env.getHsmPassword(), env.getHsmAliasName());
            if (this.privateKey == null) {
                throw new SignatureException("Error in Retrieving Key from HSM");
            }
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initSign(this.privateKey);
            byte[] shaHash = this.getSHARec(originalMessage);
            s.update(shaHash);
            signedByteArray = s.sign();
            return signedByteArray;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in SIGNING", (Throwable)e);
            throw new SignatureException();
        }
    }

    private void getPrivateKeyFromHSM(int slotNumber, String parPwd, String keyAlias) {
        if (null == this.privateKey) {
            LOGGER.info((Object)"HSM is called.");
            Luna5HSMHelper luna5hsmHelper = new Luna5HSMHelper(slotNumber, parPwd);
            try {
                luna5hsmHelper.hsmLogin();
                this.lunaStore = KeyStore.getInstance(LUNA_KEY_STORE_TYPE, LUNA5_PROVIDER);
                this.lunaStore.load(null, null);
                this.privateKey = (PrivateKey)this.lunaStore.getKey(keyAlias, null);
                this.x509Cert = (X509Certificate)this.lunaStore.getCertificate(keyAlias);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error in Retreiving Key from HSM", (Throwable)e);
            }
        } else {
            LOGGER.info((Object)"HSM is not called.");
        }
    }

    private byte[] getSHARec(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(input);
    }

    static {
        Security.addProvider((Provider)new LunaProvider());
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

