/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.appointment.service.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import in.gov.uidai.appointment.constants.IRequestConstants;
import in.gov.uidai.appointment.constants.ISignErrorContants;
import in.gov.uidai.appointment.exception.JSONValidationException;
import in.gov.uidai.appointment.exception.SignatureException;
import in.gov.uidai.appointment.model.Address;
import in.gov.uidai.appointment.model.ForeignNewEnrolmentEntity;
import in.gov.uidai.appointment.model.ForeignUpdateEnrolmentEntity;
import in.gov.uidai.appointment.model.HeadOfFamily;
import in.gov.uidai.appointment.model.NewEnrolmentEntity;
import in.gov.uidai.appointment.model.UpdateEnrolmentEntity;
import in.gov.uidai.appointment.qr.proto.AddressData;
import in.gov.uidai.appointment.qr.proto.EnrolAppointmentData;
import in.gov.uidai.appointment.qr.proto.ForeignEnrolAppointmentData;
import in.gov.uidai.appointment.qr.proto.ForeignUpdateAppointmentData;
import in.gov.uidai.appointment.qr.proto.HeadOfFamilyData;
import in.gov.uidai.appointment.qr.proto.UpdateAppointmentData;
import in.gov.uidai.appointment.service.IQrGenerator;
import in.gov.uidai.appointment.service.SignatureService;
import in.gov.uidai.appointment.service.impl.QrGeneratorService;
import in.gov.uidai.appointment.util.EnviromentProperty;
import in.gov.uidai.appointment.util.SignUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.zip.Deflater;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QrGenerator
implements IQrGenerator,
IRequestConstants,
ISignErrorContants {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrGeneratorService.class);
    private final String ENROLMENT_TAG = "newenrolment";
    private final String FOREIGN_ENROLMENT_TAG = "foreignnewenrolment";
    private final String UPDATE_TAG = "updateenrolment";
    private final String FOREIGN_UPDATE_TAG = "foreignupdateenrolment";
    private final int qrImageFrameSize = 200;
    @Autowired
    private SignUtil signUtil;
    @Autowired
    private EnviromentProperty env;
    @Autowired
    private SignatureService signatureService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getQrImage(String appointmentEntityJson) throws JSONValidationException, SignatureException, IOException, WriterException {
        String qrData;
        Type CLASS_TYPE;
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(appointmentEntityJson);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Gson gson = new Gson();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LOGGER.info("json have required tag " + jsonObject.has("foreignnewenrolment"));
        if (jsonObject.has("newenrolment")) {
            CLASS_TYPE = new TypeToken<NewEnrolmentEntity>(){}.getType();
            NewEnrolmentEntity newEnrolmentEntity = (NewEnrolmentEntity)gson.fromJson(appointmentEntityJson, CLASS_TYPE);
            if (!this.isValid(newEnrolmentEntity)) throw new JSONValidationException("Given Appointment Json contains invalid Fields");
            byte[] appointmentEnrolBytes = this.encodeToProtoBufEnrol(newEnrolmentEntity);
            if (this.env.isHsmEnable().equals("true")) {
                byte[] qrSignedBytes = this.signatureService.signForQRCode(appointmentEnrolBytes, this.env);
                LOGGER.info("Length of signature value: " + qrSignedBytes.length);
                out.write(0);
                out.write(appointmentEnrolBytes);
                out.write(qrSignedBytes);
                byte[] appointmentBytesCompressed = this.compress(out.toByteArray());
                out.close();
                qrData = new BigInteger(appointmentBytesCompressed).toString();
            } else {
                qrData = this.addSignatureWithoutHSM(appointmentEnrolBytes, (byte)0);
            }
        } else if (jsonObject.has("updateenrolment")) {
            CLASS_TYPE = new TypeToken<UpdateEnrolmentEntity>(){}.getType();
            UpdateEnrolmentEntity updateEnrolmentEntity = (UpdateEnrolmentEntity)gson.fromJson(appointmentEntityJson, CLASS_TYPE);
            if (updateEnrolmentEntity.getUpdateEnrolment().getAppointmentId().length() < 13) throw new JSONValidationException("Given Appointment Json contains invalid AppointmentID");
            byte[] appointmentUpdateBytes = this.encodeToProtoBufUpdate(updateEnrolmentEntity);
            if (this.env.isHsmEnable().equals("true")) {
                byte[] qrSignedBytes = this.signatureService.signForQRCode(appointmentUpdateBytes, this.env);
                LOGGER.info("Length of signature value: " + qrSignedBytes.length);
                out.write(1);
                out.write(appointmentUpdateBytes);
                out.write(qrSignedBytes);
                byte[] appointmentBytesCompressed = this.compress(out.toByteArray());
                out.close();
                qrData = new BigInteger(appointmentBytesCompressed).toString();
            } else {
                qrData = this.addSignatureWithoutHSM(appointmentUpdateBytes, (byte)1);
            }
        } else if (jsonObject.has("foreignnewenrolment")) {
            CLASS_TYPE = new TypeToken<ForeignNewEnrolmentEntity>(){}.getType();
            ForeignNewEnrolmentEntity foreignNewEnrolmentEntity = (ForeignNewEnrolmentEntity)gson.fromJson(appointmentEntityJson, CLASS_TYPE);
            if (!this.isDataValid(foreignNewEnrolmentEntity)) throw new JSONValidationException("Given Appointment Json contains invalid Fields");
            byte[] appointmentEnrolBytes = this.encodeToProtoBufEnrolForForeignEnrolment(foreignNewEnrolmentEntity);
            if (this.env.isHsmEnable().equals("true")) {
                byte[] qrSignedBytes = this.signatureService.signForQRCode(appointmentEnrolBytes, this.env);
                LOGGER.info("Length of signature value: " + qrSignedBytes.length);
                out.write(0);
                out.write(appointmentEnrolBytes);
                out.write(qrSignedBytes);
                byte[] appointmentBytesCompressed = this.compress(out.toByteArray());
                out.close();
                qrData = new BigInteger(appointmentBytesCompressed).toString();
            } else {
                qrData = this.addSignatureWithoutHSM(appointmentEnrolBytes, (byte)0);
            }
        } else {
            if (!jsonObject.has("foreignupdateenrolment")) throw new JSONValidationException();
            CLASS_TYPE = new TypeToken<ForeignUpdateEnrolmentEntity>(){}.getType();
            ForeignUpdateEnrolmentEntity updateEnrolmentEntity = (ForeignUpdateEnrolmentEntity)gson.fromJson(appointmentEntityJson, CLASS_TYPE);
            if (updateEnrolmentEntity.getForeignUpdateEnrolment().getAppointmentId().length() < 13) throw new JSONValidationException("Given Appointment Json contains invalid AppointmentID");
            byte[] appointmentUpdateBytes = this.encodeToProtoBufUpdateForForeign(updateEnrolmentEntity);
            if (this.env.isHsmEnable().equals("true")) {
                byte[] qrSignedBytes = this.signatureService.signForQRCode(appointmentUpdateBytes, this.env);
                LOGGER.info("Length of signature value: " + qrSignedBytes.length);
                out.write(1);
                out.write(appointmentUpdateBytes);
                out.write(qrSignedBytes);
                byte[] appointmentBytesCompressed = this.compress(out.toByteArray());
                out.close();
                qrData = new BigInteger(appointmentBytesCompressed).toString();
            } else {
                qrData = this.addSignatureWithoutHSM(appointmentUpdateBytes, (byte)1);
            }
        }
        BufferedImage qrImage = this.generateQrAsBufferedImage(qrData, 200);
        return this.encodeFromBufferedImage(qrImage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String addSignatureWithoutHSM(byte[] appointmentBytes, byte appointmentType) throws SignatureException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrivateKey key = this.signUtil.getPrivateKey();
        if (key == null) throw new SignatureException("Error in Retrieving Key from HSM");
        byte[] signature = this.signUtil.generateSignature(appointmentBytes, key);
        if (signature == null) throw new SignatureException();
        try {
            out.write(appointmentType);
            out.write(appointmentBytes);
            out.write(signature);
            byte[] appointmentBytesCompressed = this.compress(out.toByteArray());
            out.close();
            return new BigInteger(appointmentBytesCompressed).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] compress(byte[] data) {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        deflater.finish();
        byte[] buffer = new byte[2048];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    private byte[] encodeToProtoBufEnrol(NewEnrolmentEntity newEnrolmentEntity) {
        NewEnrolmentEntity.NewEnrolment newEnrolment = newEnrolmentEntity.getNewEnrolment();
        HeadOfFamily headOfFamily = newEnrolment.getHeadOfFamily();
        Address address = newEnrolment.getAddress();
        AddressData address_ = AddressData.newBuilder().setCareof(address.getCareOf()).setCareofname(address.getCareOfName()).setHouseno(address.getHouseNo()).setStreet(address.getStreet()).setLandmark(address.getLandmark()).setArea(address.getArea()).setVtc(address.getVtc()).setDistrict(address.getDistrict()).setSubdistrict(address.getSubDistrict()).setState(address.getState()).setPincode(address.getPinCode()).build();
        EnrolAppointmentData.Builder newEnrolmentBuilder_ = EnrolAppointmentData.newBuilder().setSchemaversion(newEnrolment.getSchemaVersion()).setAppointmentid(newEnrolment.getAppointmentId()).setFullname(newEnrolment.getFullName()).setGender(newEnrolment.getGender()).setDob(newEnrolment.getDob()).setAge(newEnrolment.getAge()).setIsNRI(newEnrolment.isNRI()).setAddress(address_).setMobileno(newEnrolment.getMobileNo()).setIsd(newEnrolment.getIsd()).setEmail(newEnrolment.getEmail());
        if (headOfFamily != null) {
            HeadOfFamilyData headOfFamily_ = HeadOfFamilyData.newBuilder().setType(headOfFamily.getType()).setName(headOfFamily.getName()).setEnrolmentid(headOfFamily.getEnrolmentId()).setAadharid(headOfFamily.getAadhaarId()).build();
            newEnrolmentBuilder_.setHeadoffamily(headOfFamily_);
        }
        EnrolAppointmentData enrolAppointmentData = newEnrolmentBuilder_.build();
        return enrolAppointmentData.toByteArray();
    }

    private byte[] encodeToProtoBufEnrolForForeignEnrolment(ForeignNewEnrolmentEntity foreignNewEnrolmentEntity) {
        ForeignNewEnrolmentEntity.ForeignNewEnrolment newEnrolment = foreignNewEnrolmentEntity.getForeignNewEnrolment();
        HeadOfFamily headOfFamily = newEnrolment.getHeadOfFamily();
        Address address = newEnrolment.getAddress();
        AddressData address_ = AddressData.newBuilder().setCareof(address.getCareOf()).setCareofname(address.getCareOfName()).setHouseno(address.getHouseNo()).setStreet(address.getStreet()).setLandmark(address.getLandmark()).setArea(address.getArea()).setVtc(address.getVtc()).setDistrict(address.getDistrict()).setSubdistrict(address.getSubDistrict()).setState(address.getState()).setPincode(address.getPinCode()).build();
        ForeignEnrolAppointmentData.Builder newEnrolmentBuilder_ = ForeignEnrolAppointmentData.newBuilder().setSchemaversion(newEnrolment.getSchemaVersion()).setAppointmentid(newEnrolment.getAppointmentId()).setFullname(newEnrolment.getFullName()).setGender(newEnrolment.getGender()).setDob(newEnrolment.getDob()).setAge(newEnrolment.getAge()).setIsNRI(newEnrolment.isNRI()).setAddress(address_).setMobileno(newEnrolment.getMobileNo()).setIsd(newEnrolment.getIsd()).setEmail(newEnrolment.getEmail()).setCountry(newEnrolment.getCountry()).setResidentType(newEnrolment.getResidentType());
        if (headOfFamily != null) {
            HeadOfFamilyData headOfFamily_ = HeadOfFamilyData.newBuilder().setType(headOfFamily.getType()).setName(headOfFamily.getName()).setEnrolmentid(headOfFamily.getEnrolmentId()).setAadharid(headOfFamily.getAadhaarId()).build();
            newEnrolmentBuilder_.setHeadoffamily(headOfFamily_);
        }
        ForeignEnrolAppointmentData enrolAppointmentData = newEnrolmentBuilder_.build();
        return enrolAppointmentData.toByteArray();
    }

    private byte[] encodeToProtoBufUpdate(UpdateEnrolmentEntity updateEnrolmentEntity) {
        UpdateEnrolmentEntity.UpdateEnrolment updateEnrolment = updateEnrolmentEntity.getUpdateEnrolment();
        Address address = updateEnrolment.getNewAddress();
        HeadOfFamily headOfFamily = updateEnrolment.getHeadOfFamily();
        UpdateAppointmentData.Builder updateBuilder_ = UpdateAppointmentData.newBuilder().setSchemaversion(updateEnrolment.getSchemaVersion()).setAppointmentid(updateEnrolment.getAppointmentId()).setFullname(updateEnrolment.getFullName()).setAadhaarid(String.valueOf(updateEnrolment.getAadhaarId())).setBiometricupdate(updateEnrolment.getBiometricUpdate()).setNewname(updateEnrolment.getNewName()).setNewgender(updateEnrolment.getNewGender()).setNewdob(updateEnrolment.getNewDob()).setIsNRI(updateEnrolment.isNRI()).setNewmobile(updateEnrolment.getNewMobile()).setNewisd(updateEnrolment.getNewIsd()).setNewemail(updateEnrolment.getNewEmail());
        if (address != null) {
            AddressData address_ = AddressData.newBuilder().setCareof(address.getCareOf()).setCareofname(address.getCareOfName()).setHouseno(address.getHouseNo()).setStreet(address.getStreet()).setLandmark(address.getLandmark()).setArea(address.getArea()).setVtc(address.getVtc()).setDistrict(address.getDistrict()).setSubdistrict(address.getSubDistrict()).setState(address.getState()).setPincode(address.getPinCode()).build();
            updateBuilder_.setNewaddress(address_);
        }
        if (headOfFamily != null) {
            HeadOfFamilyData headOfFamily_ = HeadOfFamilyData.newBuilder().setType(headOfFamily.getType()).setName(headOfFamily.getName()).setEnrolmentid(headOfFamily.getEnrolmentId()).setAadharid(headOfFamily.getAadhaarId()).build();
            updateBuilder_.setHeadoffamily(headOfFamily_);
        }
        UpdateAppointmentData updateAppointmentData = updateBuilder_.build();
        return updateAppointmentData.toByteArray();
    }

    private byte[] encodeToProtoBufUpdateForForeign(ForeignUpdateEnrolmentEntity updateEnrolmentEntity) {
        ForeignUpdateEnrolmentEntity.ForeignUpdateEnrolment updateEnrolment = updateEnrolmentEntity.getForeignUpdateEnrolment();
        Address address = updateEnrolment.getNewAddress();
        HeadOfFamily headOfFamily = updateEnrolment.getHeadOfFamily();
        ForeignUpdateAppointmentData.Builder updateBuilder_ = ForeignUpdateAppointmentData.newBuilder().setSchemaversion(updateEnrolment.getSchemaVersion()).setAppointmentid(updateEnrolment.getAppointmentId()).setFullname(updateEnrolment.getFullName()).setAadhaarid(String.valueOf(updateEnrolment.getAadhaarId())).setBiometricupdate(updateEnrolment.getBiometricUpdate()).setNewname(updateEnrolment.getNewName()).setNewgender(updateEnrolment.getNewGender()).setNewdob(updateEnrolment.getNewDob()).setIsNRI(updateEnrolment.isNRI()).setNewmobile(updateEnrolment.getNewMobile()).setNewisd(updateEnrolment.getNewIsd()).setNewemail(updateEnrolment.getNewEmail());
        if (address != null) {
            AddressData address_ = AddressData.newBuilder().setCareof(address.getCareOf()).setCareofname(address.getCareOfName()).setHouseno(address.getHouseNo()).setStreet(address.getStreet()).setLandmark(address.getLandmark()).setArea(address.getArea()).setVtc(address.getVtc()).setDistrict(address.getDistrict()).setSubdistrict(address.getSubDistrict()).setState(address.getState()).setPincode(address.getPinCode()).build();
            updateBuilder_.setNewaddress(address_);
        }
        if (headOfFamily != null) {
            HeadOfFamilyData headOfFamily_ = HeadOfFamilyData.newBuilder().setType(headOfFamily.getType()).setName(headOfFamily.getName()).setEnrolmentid(headOfFamily.getEnrolmentId()).setAadharid(headOfFamily.getAadhaarId()).build();
            updateBuilder_.setHeadoffamily(headOfFamily_);
        }
        ForeignUpdateAppointmentData updateAppointmentData = updateBuilder_.build();
        return updateAppointmentData.toByteArray();
    }

    private boolean isValid(NewEnrolmentEntity newEnrolmentEntity) {
        NewEnrolmentEntity.NewEnrolment newEnrolment = newEnrolmentEntity.getNewEnrolment();
        if (newEnrolment.getAppointmentId().length() != 13 && !this.isInRange(newEnrolment.getAppointmentId().length(), 20, 38)) {
            return false;
        }
        if (newEnrolment.getDob().length() == 0 && newEnrolment.getAge() == 0) {
            return false;
        }
        return newEnrolment.getAge() <= 120 && newEnrolment.getAge() >= 0;
    }

    private boolean isDataValid(ForeignNewEnrolmentEntity foreignNewEnrolmentEntity) {
        ForeignNewEnrolmentEntity.ForeignNewEnrolment newEnrolment = foreignNewEnrolmentEntity.getForeignNewEnrolment();
        if (newEnrolment.getAppointmentId().length() != 13 && !this.isInRange(newEnrolment.getAppointmentId().length(), 20, 38)) {
            return false;
        }
        if (newEnrolment.getDob().length() == 0 && newEnrolment.getAge() == 0) {
            return false;
        }
        return newEnrolment.getAge() <= 120 && newEnrolment.getAge() >= 0;
    }

    public boolean isInRange(Integer number, Integer lowerBound, Integer upperBound) {
        return lowerBound <= number && number <= upperBound;
    }

    private BufferedImage generateQrAsBufferedImage(String qrCodeData, int qrCodeSize) throws WriterException {
        HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(qrCodeData, BarcodeFormat.QR_CODE, qrCodeSize, qrCodeSize, hintMap);
        int matrixWidth = byteMatrix.getWidth();
        int matrixHeight = byteMatrix.getHeight();
        BufferedImage image = new BufferedImage(matrixWidth, matrixHeight, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, matrixWidth, matrixHeight);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < matrixHeight; ++i) {
            for (int j = 0; j < matrixWidth; ++j) {
                if (!byteMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        return image;
    }

    private String encodeFromBufferedImage(BufferedImage qrImage) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)qrImage, "png", os);
        String qrImageString = Base64.getEncoder().encodeToString(os.toByteArray());
        os.close();
        return qrImageString;
    }
}

