/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.appointment.service.impl;

import com.google.zxing.WriterException;
import in.gov.uidai.appointment.constants.IRequestConstants;
import in.gov.uidai.appointment.exception.JSONValidationException;
import in.gov.uidai.appointment.exception.SignatureException;
import in.gov.uidai.appointment.model.QrResponse;
import in.gov.uidai.appointment.service.IQrGenerator;
import in.gov.uidai.appointment.service.IQrGeneratorService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class QrGeneratorService
implements IQrGeneratorService,
IRequestConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrGeneratorService.class);
    @Autowired
    private IQrGenerator qrGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QrResponse getQrAsBase64Image(String jsonData) {
        QrResponse qrResponse = new QrResponse();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            String qrBase64Image = this.qrGenerator.getQrImage(jsonData);
            qrResponse.setStatusCode(HttpStatus.OK.value());
            qrResponse.setQrBase64Image(qrBase64Image);
            qrResponse.setMessage("Successfully generated QR Image");
            LOGGER.info("Qr Image Generated");
        }
        catch (JSONValidationException e) {
            LOGGER.error("", (Throwable)e);
            qrResponse.setStatusCode(HttpStatus.BAD_REQUEST.value());
            qrResponse.setMessage("Given Appointment Json is invalid");
        }
        catch (WriterException | SignatureException | IOException e) {
            LOGGER.error(e.getMessage(), e);
            qrResponse.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            qrResponse.setMessage(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        }
        finally {
            pw.close();
            try {
                sw.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close string writer. ", (Throwable)e);
            }
        }
        return qrResponse;
    }
}

