/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.appointment.util;

import in.gov.uidai.appointment.service.impl.QrGeneratorService;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SignUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrGeneratorService.class);
    private static final String SIGNATURE_ALGORITHM = "SHA-256";
    private String fileName;
    @Value(value="${PDKEY}")
    private String pdkey;
    @Value(value="${SIGN}")
    private String sign;
    @Value(value="${PK}")
    private String pk;
    @Value(value="${SHA}")
    private String sha;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] generateSignature(byte[] inputData, PrivateKey privateKey) {
        try {
            Signature privateSignature = Signature.getInstance(this.sha);
            privateSignature.initSign(privateKey);
            byte[] shaHash = this.getSHARec(inputData);
            privateSignature.update(shaHash);
            return privateSignature.sign();
        }
        catch (InvalidKeyException e) {
            LOGGER.error("InvalidKeyException ", (Throwable)e);
        }
        catch (SignatureException e) {
            LOGGER.error("SignatureException ", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("NoSuchAlgorithmException ", (Throwable)e);
        }
        return null;
    }

    public PrivateKey getPrivateKey() {
        try {
            KeyStore keystore = KeyStore.getInstance(this.pk);
            keystore.load(this.getClass().getClassLoader().getResourceAsStream(this.fileName), this.pdkey.toCharArray());
            PrivateKey key = (PrivateKey)keystore.getKey(this.sign, this.pdkey.toCharArray());
            return key;
        }
        catch (IOException e) {
            LOGGER.error("IOException ", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("NoSuchAlgorithmException ", (Throwable)e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private byte[] getSHARec(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(SIGNATURE_ALGORITHM);
        return md.digest(input);
    }
}

