/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg.searches;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeSearch1;

public class KdTreeSearch1Standard<P>
implements KdTreeSearch1<P> {
    private KdTree tree;
    private P target;
    private double maxDistanceSq = Double.MAX_VALUE;
    private double bestDistanceSq;
    private KdTree.Node closest;
    KdTreeDistance<P> distance;

    public KdTreeSearch1Standard(KdTreeDistance<P> distance) {
        this.distance = distance;
    }

    @Override
    public void setTree(KdTree tree) {
        this.tree = tree;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistanceSq = maxDistance;
    }

    @Override
    public KdTree.Node findNeighbor(P target) {
        if (this.tree.root == null) {
            return null;
        }
        this.target = target;
        this.closest = null;
        this.bestDistanceSq = this.maxDistanceSq;
        this.stepClosest(this.tree.root);
        return this.closest;
    }

    @Override
    public double getDistance() {
        return this.bestDistanceSq;
    }

    private void stepClosest(KdTree.Node node) {
        KdTree.Node further;
        KdTree.Node nearer;
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            double distSq;
            if (node.point != null && (distSq = this.distance.distance(node.point, this.target)) <= this.bestDistanceSq && (this.closest == null || distSq < this.bestDistanceSq)) {
                this.closest = node;
                this.bestDistanceSq = distSq;
            }
            return;
        }
        double distSq = this.distance.distance(node.point, this.target);
        if (distSq <= this.bestDistanceSq && (this.closest == null || distSq < this.bestDistanceSq)) {
            this.closest = node;
            this.bestDistanceSq = distSq;
        }
        double splitValue = this.distance.valueAt(node.point, node.split);
        double targetAtSplit = this.distance.valueAt(this.target, node.split);
        if (targetAtSplit <= splitValue) {
            nearer = node.left;
            further = node.right;
        } else {
            nearer = node.right;
            further = node.left;
        }
        this.stepClosest(nearer);
        double dx = splitValue - targetAtSplit;
        double dx2 = dx * dx;
        if (dx2 <= this.bestDistanceSq && (this.closest == null || dx2 < this.bestDistanceSq)) {
            this.stepClosest(further);
        }
    }
}

