/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg.searches;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.searches.KdTreeSearchBestBinFirst;
import org.ddogleg.struct.FastQueue;

public class KdTreeSearchNBbf<P>
extends KdTreeSearchBestBinFirst<P>
implements KdTreeSearchN<P> {
    private int searchN;
    private FastQueue<KdTreeResult> neighbors;

    public KdTreeSearchNBbf(KdTreeDistance<P> distance, int maxNodesSearched) {
        super(distance, maxNodesSearched);
    }

    @Override
    public void findNeighbor(P target, int searchN, FastQueue<KdTreeResult> results) {
        this.searchN = searchN;
        this.neighbors = results;
        this._findClosest(target);
    }

    @Override
    protected void checkBestDistance(KdTree.Node node, P target) {
        block4: {
            KdTreeResult r;
            int i;
            double distanceSq;
            block5: {
                distanceSq = this.distance.distance(node.point, target);
                if (!(distanceSq <= this.bestDistanceSq)) break block4;
                for (i = 0; i < this.neighbors.size(); ++i) {
                    r = this.neighbors.get(i);
                    if (r.node.point != node.point) continue;
                    return;
                }
                if (this.neighbors.size() >= this.searchN) break block5;
                KdTreeResult r2 = this.neighbors.grow();
                r2.distance = distanceSq;
                r2.node = node;
                if (this.neighbors.size() != this.searchN) break block4;
                this.bestDistanceSq = 0.0;
                for (int i2 = 0; i2 < this.searchN; ++i2) {
                    r2 = this.neighbors.get(i2);
                    if (!(r2.distance > this.bestDistanceSq)) continue;
                    this.bestDistanceSq = r2.distance;
                }
                break block4;
            }
            for (i = 0; i < this.searchN; ++i) {
                r = this.neighbors.get(i);
                if (r.distance != this.bestDistanceSq) continue;
                r.node = node;
                r.distance = distanceSq;
                break;
            }
            this.bestDistanceSq = 0.0;
            for (i = 0; i < this.searchN; ++i) {
                r = this.neighbors.get(i);
                if (!(r.distance > this.bestDistanceSq)) continue;
                this.bestDistanceSq = r.distance;
            }
        }
    }

    @Override
    protected boolean canImprove(double distanceSq) {
        if (distanceSq <= this.bestDistanceSq) {
            return this.neighbors.size() < this.searchN || distanceSq < this.bestDistanceSq;
        }
        return false;
    }
}

