/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.searches.KdTreeSearch1Bbf;
import org.ddogleg.nn.alg.searches.KdTreeSearchNBbf;
import org.ddogleg.struct.FastQueue;

public class KdForestBbfSearch<P>
implements NearestNeighbor<P> {
    KdTree[] forest;
    KdTreeConstructor<P> constructor;
    KdTreeSearch1Bbf search1;
    KdTreeSearchNBbf searchN;
    AxisSplitter<P> splitter;
    KdTreeMemory<P> memory = new KdTreeMemory();
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult.class, true);

    public KdForestBbfSearch(int numberOfTrees, int maxNodesSearched, KdTreeDistance<P> distance, AxisSplitter<P> splitter) {
        this.forest = new KdTree[numberOfTrees];
        this.splitter = splitter;
        this.search1 = new KdTreeSearch1Bbf<P>(distance, maxNodesSearched);
        this.searchN = new KdTreeSearchNBbf<P>(distance, maxNodesSearched);
        this.constructor = new KdTreeConstructor<P>(this.memory, splitter);
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        int i;
        if (this.forest[0] != null) {
            for (i = 0; i < this.forest.length; ++i) {
                this.memory.recycleGraph(this.forest[i]);
            }
        }
        for (i = 0; i < this.forest.length; ++i) {
            this.forest[i] = this.constructor.construct(points, trackIndicies);
        }
        this.search1.setTrees(this.forest);
        this.searchN.setTrees(this.forest);
    }

    @Override
    public boolean findNearest(P point, double maxDistance, NnData<P> result) {
        if (maxDistance < 0.0) {
            this.search1.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search1.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search1.findNeighbor(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.index = found.index;
        result.distance = this.search1.getDistance();
        return true;
    }

    @Override
    public void findNearest(P point, double maxDistance, int numNeighbors, FastQueue<NnData<P>> results) {
        results.reset();
        if (maxDistance <= 0.0) {
            this.searchN.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.searchN.setMaxDistance(maxDistance);
        }
        this.found.reset();
        this.searchN.findNeighbor(point, numNeighbors, this.found);
        for (int i = 0; i < this.found.size; ++i) {
            KdTreeResult k = this.found.get(i);
            NnData<P> r = results.grow();
            r.point = k.node.point;
            r.index = k.node.index;
            r.distance = k.distance;
        }
    }
}

