/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.searches.KdTreeSearch1Standard;
import org.ddogleg.nn.alg.searches.KdTreeSearchNStandard;
import org.ddogleg.struct.FastQueue;

public class KdTreeNearestNeighbor<P>
implements NearestNeighbor<P> {
    KdTree tree;
    KdTreeConstructor<P> constructor;
    KdTreeSearch1<P> search;
    KdTreeSearchN<P> searchN;
    AxisSplitter<P> splitter;
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult.class, true);
    KdTreeMemory<P> memory = new KdTreeMemory();

    public KdTreeNearestNeighbor(KdTreeSearch1<P> search, KdTreeSearchN<P> searchN, AxisSplitter<P> splitter) {
        this.search = search;
        this.searchN = searchN;
        this.splitter = splitter;
        this.constructor = new KdTreeConstructor<P>(this.memory, splitter);
    }

    public KdTreeNearestNeighbor(KdTreeDistance<P> distance) {
        this(new KdTreeSearch1Standard<P>(distance), new KdTreeSearchNStandard<P>(distance), new AxisSplitterMedian<P>(distance));
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        if (this.tree != null) {
            this.memory.recycleGraph(this.tree);
        }
        this.tree = this.constructor.construct(points, trackIndicies);
        this.search.setTree(this.tree);
        this.searchN.setTree(this.tree);
    }

    @Override
    public boolean findNearest(P point, double maxDistance, NnData<P> result) {
        if (maxDistance < 0.0) {
            this.search.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search.findNeighbor(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.index = found.index;
        result.distance = this.search.getDistance();
        return true;
    }

    @Override
    public void findNearest(P point, double maxDistance, int numNeighbors, FastQueue<NnData<P>> results) {
        results.reset();
        if (maxDistance <= 0.0) {
            this.searchN.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.searchN.setMaxDistance(maxDistance);
        }
        this.found.reset();
        this.searchN.findNeighbor(point, numNeighbors, this.found);
        for (int i = 0; i < this.found.size; ++i) {
            KdTreeResult k = this.found.get(i);
            NnData<P> r = results.grow();
            r.point = k.node.point;
            r.index = k.node.index;
            r.distance = k.distance;
        }
    }
}

