/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.ExhaustiveNeighbor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class WrapExhaustiveNeighbor<P>
implements NearestNeighbor<P> {
    ExhaustiveNeighbor<P> alg;
    List<P> points;
    GrowQueue_I32 outputIndex = new GrowQueue_I32();
    GrowQueue_F64 outputDistance = new GrowQueue_F64();

    public WrapExhaustiveNeighbor(KdTreeDistance<P> distance) {
        this.alg = new ExhaustiveNeighbor<P>(distance);
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        this.alg.setPoints(points);
        this.points = points;
    }

    @Override
    public boolean findNearest(P point, double maxDistance, NnData<P> result) {
        int index;
        if (maxDistance < 0.0) {
            maxDistance = Double.MAX_VALUE;
        }
        if ((index = this.alg.findClosest(point, maxDistance)) >= 0) {
            result.point = this.points.get(index);
            result.distance = this.alg.getBestDistance();
            result.index = index;
            return true;
        }
        return false;
    }

    @Override
    public void findNearest(P point, double maxDistance, int numNeighbors, FastQueue<NnData<P>> results) {
        results.reset();
        if (maxDistance < 0.0) {
            maxDistance = Double.MAX_VALUE;
        }
        this.outputIndex.reset();
        this.outputDistance.reset();
        this.alg.findClosestN(point, maxDistance, numNeighbors, this.outputIndex, this.outputDistance);
        for (int i = 0; i < this.outputIndex.size; ++i) {
            int index = this.outputIndex.get(i);
            NnData<P> r = results.grow();
            r.distance = this.outputDistance.get(i);
            r.point = this.points.get(index);
            r.index = index;
        }
    }
}

