/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.derivative.NumericalGradientForward;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DSCC;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;

public class FactoryNumericalDerivative {
    public static <D extends DMatrix> FunctionNtoMxN<D> jacobianForwards(FunctionNtoM func, Class<D> type) {
        if (type == DMatrixRMaj.class) {
            return new NumericalJacobianForward_DDRM(func);
        }
        if (type == DMatrixSparseCSC.class) {
            return new NumericalJacobianForward_DSCC(func);
        }
        throw new RuntimeException("Matrix type unknown/not supported. " + type.getSimpleName());
    }

    public static FunctionNtoN gradientForwards(FunctionNtoS func) {
        return new NumericalGradientForward(func);
    }
}

