/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import javax.annotation.Nullable;
import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.lm.UnconLeastSqLevenbergMarquardtSchur_F64;
import org.ddogleg.optimization.lm.UnconLeastSqLevenbergMarquardt_F64;
import org.ddogleg.optimization.math.HessianBFGS_DDRM;
import org.ddogleg.optimization.math.HessianLeastSquares_DDRM;
import org.ddogleg.optimization.math.HessianSchurComplement_DDRM;
import org.ddogleg.optimization.math.MatrixMath;
import org.ddogleg.optimization.math.MatrixMath_DDRM;
import org.ddogleg.optimization.quasinewton.ConfigQuasiNewton;
import org.ddogleg.optimization.quasinewton.LineSearchFletcher86;
import org.ddogleg.optimization.quasinewton.LineSearchMore94;
import org.ddogleg.optimization.quasinewton.QuasiNewtonBFGS;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ddogleg.optimization.trustregion.TrustRegionUpdateCauchy_F64;
import org.ddogleg.optimization.trustregion.TrustRegionUpdateDogleg_F64;
import org.ddogleg.optimization.trustregion.UnconLeastSqTrustRegionSchur_F64;
import org.ddogleg.optimization.trustregion.UnconLeastSqTrustRegion_F64;
import org.ddogleg.optimization.trustregion.UnconMinTrustRegionBFGS_F64;
import org.ddogleg.optimization.wrap.QuasiNewtonBFGS_to_UnconstrainedMinimization;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FactoryOptimization {
    public static UnconstrainedLeastSquaresSchur<DMatrixRMaj> doglegSchur(boolean robust, @Nullable ConfigTrustRegion config) {
        HessianSchurComplement_DDRM hessian;
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        if (robust) {
            LinearSolverDense solverA = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
            LinearSolverDense solverD = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
            hessian = new HessianSchurComplement_DDRM((LinearSolverDense<DMatrixRMaj>)solverA, (LinearSolverDense<DMatrixRMaj>)solverD);
        } else {
            hessian = new HessianSchurComplement_DDRM();
        }
        TrustRegionUpdateDogleg_F64 update = new TrustRegionUpdateDogleg_F64();
        UnconLeastSqTrustRegionSchur_F64<DMatrixRMaj> alg = new UnconLeastSqTrustRegionSchur_F64<DMatrixRMaj>((TrustRegionBase_F64.ParameterUpdate<DMatrixRMaj>)update, hessian);
        alg.configure(config);
        return alg;
    }

    public static QuasiNewtonBFGS_to_UnconstrainedMinimization quasiNewtonBfgs(@Nullable ConfigQuasiNewton config) {
        LineSearch lineSearch;
        if (config == null) {
            config = new ConfigQuasiNewton();
        }
        switch (config.lineSearch) {
            case FLETCHER86: {
                LineSearchFletcher86 fletcher86 = new LineSearchFletcher86();
                fletcher86.setConvergence(config.line_ftol, config.line_gtol);
                lineSearch = fletcher86;
                break;
            }
            case MORE94: {
                LineSearchMore94 more94 = new LineSearchMore94();
                more94.setConvergence(config.line_ftol, config.line_gtol, 0.1);
                lineSearch = more94;
                break;
            }
            default: {
                throw new RuntimeException("Unknown line search. " + (Object)((Object)config.lineSearch));
            }
        }
        QuasiNewtonBFGS qn = new QuasiNewtonBFGS(lineSearch);
        return new QuasiNewtonBFGS_to_UnconstrainedMinimization(qn);
    }

    public static UnconstrainedLeastSquares<DMatrixRMaj> dogleg(@Nullable ConfigTrustRegion config, boolean robust) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        LinearSolverDense solver = robust ? LinearSolverFactory_DDRM.leastSquaresQrPivot((boolean)true, (boolean)false) : LinearSolverFactory_DDRM.chol((int)100);
        HessianLeastSquares_DDRM hessian = new HessianLeastSquares_DDRM((LinearSolverDense<DMatrixRMaj>)solver);
        MatrixMath_DDRM math = new MatrixMath_DDRM();
        TrustRegionUpdateDogleg_F64 update = new TrustRegionUpdateDogleg_F64();
        UnconLeastSqTrustRegion_F64<DMatrixRMaj> alg = new UnconLeastSqTrustRegion_F64<DMatrixRMaj>(update, hessian, math);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedLeastSquares<DMatrixRMaj> cauchy(@Nullable ConfigTrustRegion config) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        HessianLeastSquares_DDRM hessian = new HessianLeastSquares_DDRM();
        MatrixMath_DDRM math = new MatrixMath_DDRM();
        TrustRegionUpdateCauchy_F64 update = new TrustRegionUpdateCauchy_F64();
        UnconLeastSqTrustRegion_F64<DMatrixRMaj> alg = new UnconLeastSqTrustRegion_F64<DMatrixRMaj>(update, hessian, math);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedMinimization doglegBFGS(@Nullable ConfigTrustRegion config) {
        if (config == null) {
            config = new ConfigTrustRegion();
        }
        HessianBFGS_DDRM hessian = new HessianBFGS_DDRM(true);
        TrustRegionUpdateDogleg_F64 update = new TrustRegionUpdateDogleg_F64();
        UnconMinTrustRegionBFGS_F64 alg = new UnconMinTrustRegionBFGS_F64((TrustRegionBase_F64.ParameterUpdate)update, hessian);
        alg.configure(config);
        return alg;
    }

    public static UnconstrainedLeastSquares<DMatrixRMaj> levenbergMarquardt(@Nullable ConfigLevenbergMarquardt config, boolean robust) {
        if (config == null) {
            config = new ConfigLevenbergMarquardt();
        }
        LinearSolverDense solver = robust ? LinearSolverFactory_DDRM.leastSquaresQrPivot((boolean)true, (boolean)false) : LinearSolverFactory_DDRM.chol((int)100);
        HessianLeastSquares_DDRM hessian = new HessianLeastSquares_DDRM((LinearSolverDense<DMatrixRMaj>)solver);
        UnconLeastSqLevenbergMarquardt_F64<DMatrixRMaj> lm = new UnconLeastSqLevenbergMarquardt_F64<DMatrixRMaj>((MatrixMath<DMatrixRMaj>)new MatrixMath_DDRM(), hessian);
        lm.configure(config);
        return lm;
    }

    public static UnconstrainedLeastSquaresSchur<DMatrixRMaj> levenbergMarquardtSchur(boolean robust, @Nullable ConfigLevenbergMarquardt config) {
        HessianSchurComplement_DDRM hessian;
        if (config == null) {
            config = new ConfigLevenbergMarquardt();
        }
        if (robust) {
            LinearSolverDense solverA = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
            LinearSolverDense solverD = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
            hessian = new HessianSchurComplement_DDRM((LinearSolverDense<DMatrixRMaj>)solverA, (LinearSolverDense<DMatrixRMaj>)solverD);
        } else {
            hessian = new HessianSchurComplement_DDRM();
        }
        UnconLeastSqLevenbergMarquardtSchur_F64<DMatrixRMaj> lm = new UnconLeastSqLevenbergMarquardtSchur_F64<DMatrixRMaj>((MatrixMath<DMatrixRMaj>)new MatrixMath_DDRM(), hessian);
        lm.configure(config);
        return lm;
    }
}

