/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import java.io.PrintStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ddogleg.optimization.ConfigGaussNewton;
import org.ddogleg.optimization.math.HessianMath;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public abstract class GaussNewtonBase_F64<C extends ConfigGaussNewton, HM extends HessianMath> {
    public HM hessian;
    public DMatrixRMaj x = new DMatrixRMaj(1, 1);
    public DMatrixRMaj x_next = new DMatrixRMaj(1, 1);
    public DMatrixRMaj p = new DMatrixRMaj(1, 1);
    public double fx;
    public DMatrixRMaj gradient = new DMatrixRMaj(1, 1);
    protected boolean sameStateAsCost;
    protected DMatrixRMaj hessianScaling = new DMatrixRMaj(1, 1);
    protected Mode mode = Mode.COMPUTE_DERIVATIVES;
    protected int totalFullSteps;
    protected int totalSelectSteps;
    protected PrintStream verbose;
    protected int verboseLevel = 0;
    public C config;
    public double ftest_val;
    public double gtest_val;

    public GaussNewtonBase_F64(HM hessian) {
        this.hessian = hessian;
    }

    protected GaussNewtonBase_F64() {
    }

    public void initialize(double[] initial, int numberOfParameters) {
        this.x.reshape(numberOfParameters, 1);
        this.x_next.reshape(numberOfParameters, 1);
        this.p.reshape(numberOfParameters, 1);
        this.gradient.reshape(numberOfParameters, 1);
        this.hessianScaling.reshape(numberOfParameters, 1);
        Arrays.fill(this.hessianScaling.data, 0, numberOfParameters, 1.0);
        this.hessian.init(numberOfParameters);
        System.arraycopy(initial, 0, this.x.data, 0, numberOfParameters);
        this.sameStateAsCost = true;
        this.totalFullSteps = 0;
        this.totalSelectSteps = 0;
    }

    public boolean iterate() {
        boolean converged;
        switch (this.mode) {
            case COMPUTE_DERIVATIVES: {
                ++this.totalFullSteps;
                converged = this.updateDerivates();
                if (converged) break;
                ++this.totalSelectSteps;
                converged = this.computeStep();
                break;
            }
            case DETERMINE_STEP: {
                ++this.totalSelectSteps;
                converged = this.computeStep();
                break;
            }
            case CONVERGED: {
                return true;
            }
            default: {
                throw new RuntimeException("BUG! mode=" + (Object)((Object)this.mode));
            }
        }
        if (converged) {
            this.mode = Mode.CONVERGED;
            return true;
        }
        return false;
    }

    protected abstract boolean updateDerivates();

    protected abstract boolean computeStep();

    protected void computeHessianScaling() {
        this.hessian.extractDiagonals(this.hessianScaling);
        this.computeHessianScaling(this.hessianScaling);
    }

    public void computeHessianScaling(DMatrixRMaj scaling) {
        int i;
        double max = 0.0;
        for (i = 0; i < scaling.numRows; ++i) {
            scaling.data[i] = Math.sqrt(Math.abs(scaling.data[i]));
            double v = scaling.data[i];
            if (!(v > max)) continue;
            max = v;
        }
        max *= 1.0E-12;
        i = 0;
        while (i < scaling.numRows) {
            int n = i++;
            scaling.data[n] = scaling.data[n] + max;
        }
    }

    protected void applyHessianScaling() {
        CommonOps_DDRM.elementDiv((DMatrixD1)this.gradient, (DMatrixD1)this.hessianScaling);
        this.hessian.divideRowsCols(this.hessianScaling);
    }

    protected void undoHessianScalingOnParameters(DMatrixRMaj p) {
        CommonOps_DDRM.elementDiv((DMatrixD1)p, (DMatrixD1)this.hessianScaling);
    }

    protected boolean checkConvergenceGTest(DMatrixRMaj g) {
        this.gtest_val = 0.0;
        for (int i = 0; i < g.numRows; ++i) {
            double v = Math.abs(g.data[i]);
            if (!(v > this.gtest_val)) continue;
            this.gtest_val = v;
            if (!(this.gtest_val > ((ConfigGaussNewton)this.config).gtol)) continue;
            return false;
        }
        return true;
    }

    protected abstract void functionGradientHessian(DMatrixRMaj var1, boolean var2, DMatrixRMaj var3, HM var4);

    public double computePredictedReduction(DMatrixRMaj p) {
        return -CommonOps_DDRM.dot((DMatrixD1)this.gradient, (DMatrixD1)p) - 0.5 * this.hessian.innerVectorHessian(p);
    }

    public Mode mode() {
        return this.mode;
    }

    public void setVerbose(@Nullable PrintStream out, int level) {
        this.verbose = out;
        this.verboseLevel = level;
    }

    public static enum Mode {
        COMPUTE_DERIVATIVES,
        DETERMINE_STEP,
        CONVERGED;

    }
}

