/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.lm;

import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.math.HessianMath;
import org.ddogleg.optimization.math.MatrixMath;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;

public abstract class LevenbergMarquardt_F64<S extends DMatrix, HM extends HessianMath>
extends GaussNewtonBase_F64<ConfigLevenbergMarquardt, HM> {
    public static final double MAX_LAMBDA = 1.0E100;
    protected MatrixMath<S> math;
    DMatrixRMaj residuals = new DMatrixRMaj(1, 1);
    DMatrixRMaj diagOrig = new DMatrixRMaj(1, 1);
    DMatrixRMaj diagStep = new DMatrixRMaj(1, 1);
    protected double lambda;
    protected double nu;
    private static final double NU_INITIAL = 2.0;

    public LevenbergMarquardt_F64(MatrixMath<S> math, HM hessian) {
        super(hessian);
        this.configure(new ConfigLevenbergMarquardt());
        this.math = math;
        this.hessian = hessian;
    }

    public void initialize(double[] initial, int numberOfParameters, int numberOfFunctions) {
        super.initialize(initial, numberOfParameters);
        this.lambda = ((ConfigLevenbergMarquardt)this.config).dampeningInitial;
        this.nu = 2.0;
        this.residuals.reshape(numberOfFunctions, 1);
        this.diagOrig.reshape(numberOfParameters, 1);
        this.diagStep.reshape(numberOfParameters, 1);
        this.computeResiduals(this.x, this.residuals);
        this.fx = this.costFromResiduals(this.residuals);
        this.mode = GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
        if (this.verbose != null) {
            this.verbose.println("Steps     fx        change      |step|   f-test     g-test    tr-ratio  lambda ");
            this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.2f   %6.2E\n", this.totalSelectSteps, this.fx, 0.0, 0.0, 0.0, 0.0, 0.0, this.lambda);
        }
    }

    @Override
    protected boolean updateDerivates() {
        this.functionGradientHessian(this.x, true, this.gradient, this.hessian);
        if (((ConfigLevenbergMarquardt)this.config).hessianScaling) {
            this.computeHessianScaling();
            this.applyHessianScaling();
        }
        this.hessian.extractDiagonals(this.diagOrig);
        if (this.checkConvergenceGTest(this.gradient)) {
            if (this.verbose != null) {
                this.verbose.println("Converged g-test");
            }
            return true;
        }
        this.mode = GaussNewtonBase_F64.Mode.DETERMINE_STEP;
        return false;
    }

    @Override
    protected boolean computeStep() {
        if (!this.computeStep(this.lambda, this.gradient, this.p)) {
            if (((ConfigLevenbergMarquardt)this.config).mixture == 0.0) {
                throw new OptimizationException("Singular matrix encountered. Try setting mixture to a non-zero value");
            }
            this.lambda *= 4.0;
            if (this.verbose != null) {
                this.verbose.println(this.totalFullSteps + " Step computation failed. Increasing lambda");
            }
            return this.maximumLambdaNu();
        }
        if (((ConfigLevenbergMarquardt)this.config).hessianScaling) {
            this.undoHessianScalingOnParameters(this.p);
        }
        CommonOps_DDRM.add((DMatrixD1)this.x, (DMatrixD1)this.p, (DMatrixD1)this.x_next);
        this.computeResiduals(this.x_next, this.residuals);
        double fx_candidate = this.costFromResiduals(this.residuals);
        if (UtilEjml.isUncountable((double)fx_candidate)) {
            throw new OptimizationException("Uncountable candidate score: " + fx_candidate);
        }
        double actualReduction = this.fx - fx_candidate;
        double predictedReduction = this.computePredictedReduction(this.p);
        if (actualReduction == 0.0 || predictedReduction == 0.0) {
            if (this.verbose != null) {
                this.verbose.println(this.totalFullSteps + " reduction of zero");
            }
            return true;
        }
        return this.processStepResults(fx_candidate, actualReduction, predictedReduction);
    }

    private boolean processStepResults(double fx_candidate, double actualReduction, double predictedReduction) {
        boolean accepted;
        double ratio = actualReduction / predictedReduction;
        if (fx_candidate < this.fx) {
            this.lambda *= Math.max(0.3333333333333333, 1.0 - Math.pow(2.0 * ratio - 1.0, 3.0));
            this.nu = 2.0;
            accepted = true;
        } else {
            this.lambda *= this.nu;
            this.nu *= 2.0;
            accepted = false;
        }
        if (UtilEjml.isUncountable((double)this.lambda) || UtilEjml.isUncountable((double)this.nu)) {
            throw new OptimizationException("BUG! lambda=" + this.lambda + "  nu=" + this.nu);
        }
        if (accepted) {
            boolean converged = this.checkConvergenceFTest(fx_candidate, this.fx);
            if (this.verbose != null) {
                double length_p = NormOps_DDRM.normF((DMatrixD1)this.p);
                this.verbose.printf("%-4d  %9.3E  %10.3E  %9.3E  %9.3E  %9.3E  %6.3f   %6.2E\n", this.totalSelectSteps, fx_candidate, fx_candidate - this.fx, length_p, this.ftest_val, this.gtest_val, ratio, this.lambda);
                if (converged) {
                    this.verbose.println("Converged f-test");
                }
            }
            this.acceptNewState(fx_candidate);
            return this.maximumLambdaNu() || converged;
        }
        return false;
    }

    private void acceptNewState(double fx_candidate) {
        DMatrixRMaj tmp = this.x;
        this.x = this.x_next;
        this.x_next = tmp;
        this.fx = fx_candidate;
        this.mode = GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    protected boolean checkConvergenceFTest(double fx, double fx_prev) {
        if (fx_prev < fx) {
            throw new OptimizationException("Score got worse. Shoul have been caught earlier!");
        }
        this.ftest_val = 1.0 - fx / fx_prev;
        return ((ConfigLevenbergMarquardt)this.config).ftol * fx_prev >= fx_prev - fx;
    }

    public double costFromResiduals(DMatrixRMaj residuals) {
        return 0.5 * SpecializedOps_DDRM.elementSumSq((DMatrixD1)residuals);
    }

    protected boolean computeStep(double lambda, DMatrixRMaj gradient, DMatrixRMaj step) {
        double mixture = ((ConfigLevenbergMarquardt)this.config).mixture;
        for (int i = 0; i < this.diagOrig.numRows; ++i) {
            double v = Math.min(((ConfigLevenbergMarquardt)this.config).diagonal_max, Math.max(((ConfigLevenbergMarquardt)this.config).diagonal_min, this.diagOrig.data[i]));
            this.diagStep.data[i] = v + lambda * (mixture + (1.0 - mixture) * v);
        }
        this.hessian.setDiagonals(this.diagStep);
        if (!this.hessian.initializeSolver()) {
            return false;
        }
        if (this.hessian.solve(gradient, step)) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)step);
            return true;
        }
        return false;
    }

    public boolean maximumLambdaNu() {
        return UtilEjml.isUncountable((double)this.lambda) || this.lambda >= 1.0E100 || UtilEjml.isUncountable((double)this.nu);
    }

    protected abstract void computeResiduals(DMatrixRMaj var1, DMatrixRMaj var2);

    public void configure(ConfigLevenbergMarquardt config) {
        this.config = config.copy();
    }
}

