/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianBFGS;
import org.ddogleg.optimization.math.HessianMath_DDRM;
import org.ddogleg.optimization.quasinewton.EquationsBFGS;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class HessianBFGS_DDRM
extends HessianMath_DDRM
implements HessianBFGS {
    boolean computeInverse;
    DMatrixRMaj hessianInverse = new DMatrixRMaj(1, 1);
    private DMatrixRMaj tmpN1 = new DMatrixRMaj(1, 1);
    private DMatrixRMaj tmpN2 = new DMatrixRMaj(1, 1);

    public HessianBFGS_DDRM(boolean computeInverse) {
        this.computeInverse = computeInverse;
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        throw new IllegalArgumentException("Scaling with BFGS is currently not supported. A scaled and unscaled H and inv(H) need to be maintained");
    }

    @Override
    public void init(int numParameters) {
        super.init(numParameters);
        this.hessianInverse.reshape(numParameters, numParameters);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.hessian);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.hessianInverse);
    }

    @Override
    public void update(DMatrixRMaj s, DMatrixRMaj y) {
        EquationsBFGS.update(this.hessian, s, y, this.tmpN1, this.tmpN2);
        if (this.computeInverse) {
            EquationsBFGS.inverseUpdate(this.hessianInverse, s, y, this.tmpN1, this.tmpN2);
        }
    }

    @Override
    public boolean initializeSolver() {
        return true;
    }

    @Override
    public boolean solve(DMatrixRMaj Y, DMatrixRMaj step) {
        if (!this.computeInverse) {
            throw new RuntimeException("Can't solve since configured to not compute the inverse");
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.hessianInverse, (DMatrix1Row)Y, (DMatrix1Row)step);
        return true;
    }
}

