/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianMath;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class HessianMath_DDRM
implements HessianMath {
    protected LinearSolver<DMatrixRMaj, DMatrixRMaj> solver;
    protected DMatrixRMaj hessian = new DMatrixRMaj(1, 1);

    public HessianMath_DDRM() {
    }

    public HessianMath_DDRM(LinearSolverDense<DMatrixRMaj> solver) {
        this.solver = UtilEjml.safe(solver);
    }

    @Override
    public void init(int numParameters) {
        this.hessian.reshape(numParameters, numParameters);
    }

    @Override
    public double innerVectorHessian(DMatrixRMaj v) {
        return VectorVectorMult_DDRM.innerProdA((DMatrixD1)v, (DMatrixD1)this.hessian, (DMatrixD1)v);
    }

    @Override
    public void extractDiagonals(DMatrixRMaj diag) {
        CommonOps_DDRM.extractDiag((DMatrixRMaj)this.hessian, (DMatrixRMaj)diag);
    }

    @Override
    public void setDiagonals(DMatrixRMaj diag) {
        for (int i = 0; i < this.hessian.numRows; ++i) {
            this.hessian.set(i, i, diag.data[i]);
        }
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        CommonOps_DDRM.divideCols((DMatrixRMaj)this.hessian, (double[])scaling.data);
        CommonOps_DDRM.divideRows((double[])scaling.data, (DMatrixRMaj)this.hessian);
    }

    @Override
    public boolean initializeSolver() {
        if (this.solver == null) {
            throw new RuntimeException("Solver not set");
        }
        return this.solver.setA((Matrix)this.hessian);
    }

    @Override
    public boolean solve(DMatrixRMaj Y, DMatrixRMaj step) {
        this.solver.solve((Matrix)Y, (Matrix)step);
        return true;
    }

    public DMatrixRMaj getHessian() {
        return this.hessian;
    }
}

