/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianMath;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.mult.MatrixVectorMult_DSCC;

public class HessianMath_DSCC
implements HessianMath {
    LinearSolver<DMatrixSparseCSC, DMatrixRMaj> solver;
    DMatrixSparseCSC hessian = new DMatrixSparseCSC(1, 1);

    public HessianMath_DSCC() {
    }

    public HessianMath_DSCC(LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver) {
        this.solver = UtilEjml.safe(solver);
    }

    @Override
    public void init(int numParameters) {
        this.hessian.reshape(numParameters, numParameters);
    }

    @Override
    public double innerVectorHessian(DMatrixRMaj v) {
        return MatrixVectorMult_DSCC.innerProduct((double[])v.data, (int)0, (DMatrixSparseCSC)this.hessian, (double[])v.data, (int)0);
    }

    @Override
    public void extractDiagonals(DMatrixRMaj diag) {
        CommonOps_DSCC.extractDiag((DMatrixSparseCSC)this.hessian, (DMatrixRMaj)diag);
    }

    @Override
    public void setDiagonals(DMatrixRMaj diag) {
        for (int i = 0; i < this.hessian.numRows; ++i) {
            this.hessian.set(i, i, diag.data[i]);
        }
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        CommonOps_DSCC.divideRowsCols((double[])scaling.data, (int)0, (DMatrixSparseCSC)this.hessian, (double[])scaling.data, (int)0);
    }

    @Override
    public boolean initializeSolver() {
        if (this.solver == null) {
            throw new RuntimeException("Solver not set");
        }
        return this.solver.setA((Matrix)this.hessian);
    }

    @Override
    public boolean solve(DMatrixRMaj Y, DMatrixRMaj step) {
        this.solver.solve((Matrix)Y, (Matrix)step);
        return true;
    }
}

