/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianSchurComplement;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.interfaces.linsol.LinearSolverSparse;

public abstract class HessianSchurComplement_Base<S extends DMatrix>
implements HessianSchurComplement<S> {
    S A;
    S B;
    S D;
    DMatrixRMaj b1 = new DMatrixRMaj(1, 1);
    DMatrixRMaj b2 = new DMatrixRMaj(1, 1);
    DMatrixRMaj b2_m = new DMatrixRMaj(1, 1);
    DMatrixRMaj x = new DMatrixRMaj(1, 1);
    DMatrixRMaj x1 = new DMatrixRMaj(1, 1);
    DMatrixRMaj x2 = new DMatrixRMaj(1, 1);
    S tmp0;
    S D_m;
    protected LinearSolverSparse<S, DMatrixRMaj> solverA;
    protected LinearSolverSparse<S, DMatrixRMaj> solverD;

    public HessianSchurComplement_Base(LinearSolverSparse<S, DMatrixRMaj> solverA, LinearSolverSparse<S, DMatrixRMaj> solverD) {
        this.solverA = solverA;
        this.solverD = solverD;
        this.A = this.createMatrix();
        this.B = this.createMatrix();
        this.D = this.createMatrix();
        this.tmp0 = this.createMatrix();
        this.D_m = this.createMatrix();
    }

    @Override
    public void init(int numParameters) {
    }

    @Override
    public double innerVectorHessian(DMatrixRMaj v) {
        int M = this.A.getNumRows();
        double sum = 0.0;
        sum += this.innerProduct(v.data, 0, this.A, v.data, 0);
        sum += 2.0 * this.innerProduct(v.data, 0, this.B, v.data, M);
        return sum += this.innerProduct(v.data, M, this.D, v.data, M);
    }

    @Override
    public void extractDiagonals(DMatrixRMaj diag) {
        this.extractDiag(this.A, this.x1);
        this.extractDiag(this.D, this.x2);
        diag.reshape(this.A.getNumCols() + this.D.getNumCols(), 1);
        CommonOps_DDRM.insert((DMatrix)this.x1, (DMatrix)diag, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.x2, (DMatrix)diag, (int)this.x1.numRows, (int)0);
    }

    @Override
    public void setDiagonals(DMatrixRMaj diag) {
        int N = this.A.getNumCols();
        for (int i = 0; i < N; ++i) {
            this.A.set(i, i, diag.data[i]);
        }
        int D_cols = this.D.getNumCols();
        for (int i = 0; i < D_cols; ++i) {
            this.D.set(i, i, diag.data[i + N]);
        }
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        double[] d = scaling.data;
        this.divideRowsCols(d, 0, this.A, d, 0);
        this.divideRowsCols(d, 0, this.B, d, this.A.getNumCols());
        this.divideRowsCols(d, this.A.getNumRows(), this.D, d, this.A.getNumCols());
    }

    @Override
    public boolean initializeSolver() {
        return this.solverA.setA(this.A);
    }

    @Override
    public boolean solve(DMatrixRMaj gradient, DMatrixRMaj step) {
        CommonOps_DDRM.extract((DMatrix)gradient, (int)0, (int)this.A.getNumCols(), (int)0, (int)gradient.numCols, (DMatrix)this.b1);
        CommonOps_DDRM.extract((DMatrix)gradient, (int)this.A.getNumCols(), (int)gradient.numRows, (int)0, (int)gradient.numCols, (DMatrix)this.b2);
        this.x.reshape(this.A.getNumRows(), 1);
        this.solverA.solve((Matrix)this.b1, (Matrix)this.x);
        this.multTransA(this.B, this.x, this.b2_m);
        CommonOps_DDRM.subtract((DMatrixD1)this.b2, (DMatrixD1)this.b2_m, (DMatrixD1)this.b2_m);
        ((ReshapeMatrix)this.D_m).reshape(this.A.getNumRows(), this.B.getNumCols());
        this.solverA.solveSparse(this.B, this.D_m);
        this.multTransA(this.B, this.D_m, this.tmp0);
        this.add(1.0, this.D, -1.0, this.tmp0, this.D_m);
        if (!this.solverD.setA(this.D_m)) {
            return false;
        }
        this.x2.reshape(this.D_m.getNumRows(), this.b2_m.numCols);
        this.solverD.solve((Matrix)this.b2_m, (Matrix)this.x2);
        this.mult(this.B, this.x2, this.x1);
        CommonOps_DDRM.subtract((DMatrixD1)this.b1, (DMatrixD1)this.x1, (DMatrixD1)this.b1);
        this.solverA.solve((Matrix)this.b1, (Matrix)this.x1);
        CommonOps_DDRM.insert((DMatrix)this.x1, (DMatrix)step, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.x2, (DMatrix)step, (int)this.x1.numRows, (int)0);
        return true;
    }

    @Override
    public void computeGradient(S jacLeft, S jacRight, DMatrixRMaj residuals, DMatrixRMaj gradient) {
        this.x1.reshape(jacLeft.getNumCols(), 1);
        this.x2.reshape(jacRight.getNumCols(), 1);
        this.multTransA(jacLeft, residuals, this.x1);
        this.multTransA(jacRight, residuals, this.x2);
        CommonOps_DDRM.insert((DMatrix)this.x1, (DMatrix)gradient, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.x2, (DMatrix)gradient, (int)this.x1.numRows, (int)0);
    }

    protected abstract double innerProduct(double[] var1, int var2, S var3, double[] var4, int var5);

    protected abstract void extractDiag(S var1, DMatrixRMaj var2);

    protected abstract void divideRowsCols(double[] var1, int var2, S var3, double[] var4, int var5);

    protected abstract void multTransA(S var1, S var2, S var3);

    protected abstract void multTransA(S var1, DMatrixRMaj var2, DMatrixRMaj var3);

    protected abstract void add(double var1, S var3, double var4, S var6, S var7);

    protected abstract void mult(S var1, DMatrixRMaj var2, DMatrixRMaj var3);
}

