/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.quasinewton;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;

public class EquationsBFGS {
    public static void update(DMatrixRMaj H, DMatrixRMaj s, DMatrixRMaj y, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        double p = VectorVectorMult_DDRM.innerProd((DMatrixD1)y, (DMatrixD1)s);
        if (p == 0.0) {
            return;
        }
        p = 1.0 / p;
        double sBs = VectorVectorMult_DDRM.innerProdA((DMatrixD1)s, (DMatrixD1)H, (DMatrixD1)s);
        if (sBs == 0.0) {
            return;
        }
        CommonOps_DDRM.mult((DMatrix1Row)H, (DMatrix1Row)s, (DMatrix1Row)tempV0);
        CommonOps_DDRM.multTransA((DMatrix1Row)s, (DMatrix1Row)H, (DMatrix1Row)tempV1);
        VectorVectorMult_DDRM.rank1Update((double)(-p), (DMatrixRMaj)H, (DMatrixRMaj)tempV0, (DMatrixRMaj)y);
        VectorVectorMult_DDRM.rank1Update((double)(-p), (DMatrixRMaj)H, (DMatrixRMaj)y, (DMatrixRMaj)tempV1);
        VectorVectorMult_DDRM.rank1Update((double)(p * (p * sBs + 1.0)), (DMatrixRMaj)H, (DMatrixRMaj)y, (DMatrixRMaj)y);
    }

    public static void inverseUpdate(DMatrixRMaj H, DMatrixRMaj s, DMatrixRMaj y, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        double alpha = VectorVectorMult_DDRM.innerProdA((DMatrixD1)y, (DMatrixD1)H, (DMatrixD1)y);
        double p = 1.0 / VectorVectorMult_DDRM.innerProd((DMatrixD1)s, (DMatrixD1)y);
        CommonOps_DDRM.mult((DMatrix1Row)H, (DMatrix1Row)y, (DMatrix1Row)tempV0);
        CommonOps_DDRM.multTransA((DMatrix1Row)y, (DMatrix1Row)H, (DMatrix1Row)tempV1);
        VectorVectorMult_DDRM.rank1Update((double)(-p), (DMatrixRMaj)H, (DMatrixRMaj)tempV0, (DMatrixRMaj)s);
        VectorVectorMult_DDRM.rank1Update((double)(-p), (DMatrixRMaj)H, (DMatrixRMaj)s, (DMatrixRMaj)tempV1);
        VectorVectorMult_DDRM.rank1Update((double)(p * alpha * p + p), (DMatrixRMaj)H, (DMatrixRMaj)s, (DMatrixRMaj)s);
    }

    public static void conjugateUpdateD(DMatrixRMaj C, DMatrixRMaj d, DMatrixRMaj y, double step, DMatrixRMaj tempV0) {
        DMatrixRMaj z = tempV0;
        CommonOps_DDRM.multTransA((DMatrix1Row)C, (DMatrix1Row)y, (DMatrix1Row)z);
        double dTd = VectorVectorMult_DDRM.innerProd((DMatrixD1)d, (DMatrixD1)d);
        double dTz = VectorVectorMult_DDRM.innerProd((DMatrixD1)d, (DMatrixD1)z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }

    public static void conjugateUpdateC(DMatrixRMaj C, DMatrixRMaj d, DMatrixRMaj y, double step, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        DMatrixRMaj z = tempV0;
        DMatrixRMaj d_bar = tempV1;
        CommonOps_DDRM.multTransA((DMatrix1Row)C, (DMatrix1Row)y, (DMatrix1Row)z);
        double dTd = VectorVectorMult_DDRM.innerProd((DMatrixD1)d, (DMatrixD1)d);
        double dTz = VectorVectorMult_DDRM.innerProd((DMatrixD1)d, (DMatrixD1)z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }
}

