/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.quasinewton;

public class SearchInterpolate {
    public static double quadratic(double f0, double g0, double x0, double f1, double x1) {
        return x0 + g0 / ((f0 - f1) / (x1 - x0) + g0) / 2.0 * (x1 - x0);
    }

    public static double quadratic2(double g0, double x0, double g1, double x1) {
        return x0 + g0 / (g0 - g1) * (x1 - x0);
    }

    public static double cubic(double f0, double g0, double f1, double alpha1, double f2, double alpha2) {
        double denominator = alpha1 * alpha1 * alpha2 * alpha2 * (alpha2 - alpha1);
        double a11 = alpha1 * alpha1 / denominator;
        double a12 = -alpha2 * alpha2 / denominator;
        double a21 = -alpha1 * a11;
        double a22 = -alpha2 * a12;
        double y1 = f2 - f0 - g0 * alpha2;
        double y2 = f1 - f0 - g0 * alpha1;
        double a = a11 * y1 + a12 * y2;
        double b = a21 * y1 + a22 * y2;
        return (-b + Math.sqrt(b * b - 3.0 * a * g0)) / (3.0 * a);
    }

    public static double cubic2(double f0, double g0, double x0, double f1, double g1, double x1) {
        double theta = 3.0 * (f0 - f1) / (x1 - x0) + g0 + g1;
        double s = Math.max(Math.abs(theta), Math.abs(g0));
        s = Math.max(s, Math.abs(g1));
        double gamma = s * Math.sqrt(theta / s * (theta / s) - g0 / s * (g1 / s));
        if (x1 < x0) {
            gamma = -gamma;
        }
        double p = gamma - g0 + theta;
        double q = gamma - g0 + gamma + g1;
        return x0 + p / q * (x1 - x0);
    }

    public static double cubicSafe(double f0, double g0, double x0, double f1, double g1, double x1, double min, double max) {
        double q;
        double p;
        double r;
        double theta = 3.0 * (f0 - f1) / (x1 - x0) + g0 + g1;
        double s = Math.max(Math.abs(theta), Math.abs(g0));
        s = Math.max(s, Math.abs(g1));
        double gamma = s * Math.sqrt(theta / s * (theta / s) - g0 / s * (g1 / s));
        if (x1 < x0) {
            gamma = -gamma;
        }
        if ((r = (p = gamma - g0 + theta) / (q = gamma + (g1 - g0) + gamma)) < 0.0 && gamma != 0.0) {
            return x0 + r * (x1 - x0);
        }
        if (x0 > x1) {
            return max;
        }
        return min;
    }
}

