/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import java.io.PrintStream;
import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class TrustRegionUpdateCauchy_F64<S extends DMatrix>
implements TrustRegionBase_F64.ParameterUpdate<S> {
    private TrustRegionBase_F64<S, ?> owner;
    DMatrixRMaj direction = new DMatrixRMaj(1, 1);
    double gBg;
    double predictedReduction;
    double stepLength;
    PrintStream verbose = null;

    @Override
    public void initialize(TrustRegionBase_F64<S, ?> owner, int numberOfParameters, double minimumFunctionValue) {
        this.owner = owner;
        this.direction.reshape(numberOfParameters, 1);
    }

    @Override
    public void initializeUpdate() {
        CommonOps_DDRM.divide((DMatrixD1)this.owner.gradient, (double)this.owner.gradientNorm, (DMatrixD1)this.direction);
        this.gBg = this.owner.hessian.innerVectorHessian(this.direction);
        if (UtilEjml.isUncountable((double)this.gBg)) {
            throw new OptimizationException("Uncountable. gBg=" + this.gBg);
        }
    }

    @Override
    public void computeUpdate(DMatrixRMaj step, double regionRadius) {
        double gnorm = this.owner.gradientNorm;
        if (this.gBg <= 0.0) {
            if (this.verbose != null) {
                this.verbose.println("  not-positive definite. dBd <= 0");
            }
            this.stepLength = regionRadius;
        } else {
            if (this.verbose != null) {
                this.verbose.println("  normal step");
            }
            this.stepLength = Math.min(regionRadius, gnorm / this.gBg);
        }
        CommonOps_DDRM.scale((double)(-this.stepLength), (DMatrixD1)this.direction, (DMatrixD1)step);
        this.predictedReduction = this.stepLength * (this.owner.gradientNorm - 0.5 * this.stepLength * this.gBg);
    }

    @Override
    public double getPredictedReduction() {
        return this.predictedReduction;
    }

    @Override
    public double getStepLength() {
        return this.stepLength;
    }

    @Override
    public void setVerbose(PrintStream out, int level) {
        this.verbose = out;
    }
}

