/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import org.ddogleg.optimization.FactoryNumericalDerivative;
import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.math.HessianLeastSquares;
import org.ddogleg.optimization.math.MatrixMath;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.SpecializedOps_DDRM;

public class UnconLeastSqTrustRegion_F64<S extends DMatrix>
extends TrustRegionBase_F64<S, HessianLeastSquares<S>>
implements UnconstrainedLeastSquares<S> {
    protected MatrixMath<S> math;
    protected DMatrixRMaj residuals = new DMatrixRMaj(1, 1);
    protected S jacobian;
    protected FunctionNtoM functionResiduals;
    protected FunctionNtoMxN<S> functionJacobian;

    public UnconLeastSqTrustRegion_F64(TrustRegionBase_F64.ParameterUpdate<S> parameterUpdate, HessianLeastSquares<S> hessian, MatrixMath<S> math) {
        super(parameterUpdate, hessian);
        this.math = math;
        this.jacobian = math.createMatrix();
    }

    @Override
    public void setFunction(FunctionNtoM function, FunctionNtoMxN<S> jacobian) {
        this.functionResiduals = function;
        this.functionJacobian = jacobian == null ? FactoryNumericalDerivative.jacobianForwards(function, this.jacobian.getClass()) : jacobian;
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.initialize(initial, this.functionResiduals.getNumOfInputsN(), 0.0);
        ((ConfigTrustRegion)this.config).ftol = ftol;
        ((ConfigTrustRegion)this.config).gtol = gtol;
    }

    @Override
    public void initialize(double[] initial, int numberOfParameters, double minimumFunctionValue) {
        int M = this.functionResiduals.getNumOfOutputsM();
        int N = this.functionResiduals.getNumOfInputsN();
        this.residuals.reshape(M, 1);
        ((HessianLeastSquares)this.hessian).init(numberOfParameters);
        ((ReshapeMatrix)this.jacobian).reshape(M, N);
        super.initialize(initial, numberOfParameters, minimumFunctionValue);
    }

    @Override
    protected double cost(DMatrixRMaj x) {
        this.functionResiduals.process(x.data, this.residuals.data);
        return 0.5 * SpecializedOps_DDRM.elementSumSq((DMatrixD1)this.residuals);
    }

    @Override
    protected void functionGradientHessian(DMatrixRMaj x, boolean sameStateAsCost, DMatrixRMaj gradient, HessianLeastSquares<S> hessian) {
        if (!sameStateAsCost) {
            this.functionResiduals.process(x.data, this.residuals.data);
        }
        this.functionJacobian.process(x.data, this.jacobian);
        hessian.updateHessian(this.jacobian);
        this.math.multTransA(this.jacobian, this.residuals, gradient);
    }

    @Override
    public double[] getParameters() {
        return this.x.data;
    }

    @Override
    public double getFunctionValue() {
        return this.fx;
    }

    @Override
    public boolean isUpdated() {
        return this.mode == GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    @Override
    public boolean isConverged() {
        return this.mode == GaussNewtonBase_F64.Mode.CONVERGED;
    }

    public DMatrixRMaj getResiduals() {
        return this.residuals;
    }

    public S getJacobian() {
        return this.jacobian;
    }
}

