/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import org.ddogleg.optimization.FactoryNumericalDerivative;
import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.math.HessianBFGS;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class UnconMinTrustRegionBFGS_F64
extends TrustRegionBase_F64<DMatrixRMaj, HessianBFGS>
implements UnconstrainedMinimization {
    private DMatrixRMaj y = new DMatrixRMaj(1, 1);
    private DMatrixRMaj gradientPrevious = new DMatrixRMaj(1, 1);
    private DMatrixRMaj xPrevious = new DMatrixRMaj(1, 1);
    private DMatrixRMaj s = new DMatrixRMaj(1, 1);
    protected double f_prev;
    private FunctionNtoS functionCost;
    private FunctionNtoN functionGradient;
    private double minimumFunctionValue;
    private boolean firstIteration;
    double c1 = 1.0E-4;
    double c2 = 0.9;

    public UnconMinTrustRegionBFGS_F64(TrustRegionBase_F64.ParameterUpdate parameterUpdate, HessianBFGS hessian) {
        super(parameterUpdate, hessian);
    }

    @Override
    public void setFunction(FunctionNtoS function, FunctionNtoN gradient, double minFunctionValue) {
        this.functionCost = function;
        this.functionGradient = gradient == null ? FactoryNumericalDerivative.gradientForwards(function) : gradient;
        this.minimumFunctionValue = minFunctionValue;
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.initialize(initial, this.functionCost.getNumOfInputsN(), this.minimumFunctionValue);
        ((ConfigTrustRegion)this.config).ftol = ftol;
        ((ConfigTrustRegion)this.config).gtol = gtol;
    }

    @Override
    public void initialize(double[] initial, int numberOfParameters, double minimumFunctionValue) {
        super.initialize(initial, numberOfParameters, minimumFunctionValue);
        this.y.reshape(numberOfParameters, 1);
        this.xPrevious.reshape(numberOfParameters, 1);
        this.x.reshape(numberOfParameters, 1);
        this.gradientPrevious.reshape(numberOfParameters, 1);
        this.gradientPrevious.zero();
        this.firstIteration = true;
    }

    @Override
    protected double cost(DMatrixRMaj x) {
        return this.functionCost.process(x.data);
    }

    @Override
    protected void functionGradientHessian(DMatrixRMaj x, boolean sameStateAsCost, DMatrixRMaj gradient, HessianBFGS hessian) {
        this.functionGradient.process(x.data, gradient.data);
        if (!this.firstIteration) {
            CommonOps_DDRM.subtract((DMatrixD1)gradient, (DMatrixD1)this.gradientPrevious, (DMatrixD1)this.y);
            CommonOps_DDRM.subtract((DMatrixD1)x, (DMatrixD1)this.xPrevious, (DMatrixD1)this.s);
            if (this.wolfeCondition(this.s, this.y, this.gradientPrevious)) {
                hessian.update(this.s, this.y);
                this.gradientPrevious.set((DMatrixD1)gradient);
                this.xPrevious.set((DMatrixD1)x);
                this.f_prev = this.fx;
            }
        } else {
            this.firstIteration = false;
            this.gradientPrevious.set((DMatrixD1)gradient);
            this.xPrevious.set((DMatrixD1)x);
            this.f_prev = this.fx;
        }
    }

    protected boolean wolfeCondition(DMatrixRMaj s, DMatrixRMaj y, DMatrixRMaj g_k) {
        double g_s;
        double right;
        double left = CommonOps_DDRM.dot((DMatrixD1)y, (DMatrixD1)s);
        if (left >= (right = (this.c2 - 1.0) * (g_s = CommonOps_DDRM.dot((DMatrixD1)g_k, (DMatrixD1)s)))) {
            return this.fx - this.f_prev <= this.c1 * g_s;
        }
        return false;
    }

    @Override
    public double[] getParameters() {
        return this.x.data;
    }

    @Override
    public double getFunctionValue() {
        return this.fx;
    }

    @Override
    public boolean isUpdated() {
        return this.mode == GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    @Override
    public boolean isConverged() {
        return this.mode == GaussNewtonBase_F64.Mode.CONVERGED;
    }
}

