/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.derivative.NumericalDerivativeForward;
import org.ddogleg.optimization.derivative.NumericalGradientForward;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.functions.FunctionStoS;
import org.ddogleg.optimization.functions.GradientLineFunction;

public class CachedNumericalGradientLineFunction
implements GradientLineFunction {
    protected int N;
    protected double[] start;
    protected double[] direction;
    protected boolean cachedFunction;
    protected boolean cachedGradient;
    protected boolean cachedDerivative;
    protected double[] currentInput;
    protected double[] currentGradient;
    protected double currentOutput;
    protected double currentStep;
    protected double currentDerivative;
    protected FunctionNtoS function;
    protected FunctionNtoN gradient;
    protected FunctionStoS lineDerivative;

    public CachedNumericalGradientLineFunction(FunctionNtoS function) {
        this.function = function;
        this.N = function.getNumOfInputsN();
        this.gradient = new NumericalGradientForward(function);
        LineFunction lineFunction = new LineFunction();
        this.lineDerivative = new NumericalDerivativeForward(lineFunction);
        this.currentInput = new double[this.N];
        this.currentGradient = new double[this.N];
    }

    @Override
    public void setLine(double[] start, double[] direction) {
        this.start = start;
        this.direction = direction;
    }

    @Override
    public double[] getCurrentState() {
        return this.currentInput;
    }

    @Override
    public void setInput(double x) {
        for (int i = 0; i < this.N; ++i) {
            this.currentInput[i] = this.start[i] + x * this.direction[i];
        }
        this.currentStep = x;
        this.cachedFunction = false;
        this.cachedGradient = false;
        this.cachedDerivative = false;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public void setInput(double[] x) {
        System.arraycopy(x, 0, this.currentInput, 0, this.N);
        this.currentStep = Double.NaN;
        this.cachedFunction = false;
        this.cachedGradient = false;
        this.cachedDerivative = false;
    }

    @Override
    public double computeFunction() {
        if (this.cachedFunction) {
            return this.currentOutput;
        }
        this.currentOutput = this.function.process(this.currentInput);
        this.cachedFunction = true;
        return this.currentOutput;
    }

    @Override
    public void computeGradient(double[] gradient) {
        if (!this.cachedGradient) {
            this.cachedGradient = true;
            this.gradient.process(this.currentInput, this.currentGradient);
        }
        System.arraycopy(this.currentGradient, 0, gradient, 0, this.N);
    }

    @Override
    public double computeDerivative() {
        if (!this.cachedDerivative) {
            this.cachedDerivative = true;
            this.currentDerivative = this.lineDerivative.process(this.currentStep);
        }
        return this.currentDerivative;
    }

    private class LineFunction
    implements FunctionStoS {
        double[] point;

        private LineFunction() {
            this.point = new double[CachedNumericalGradientLineFunction.this.N];
        }

        @Override
        public double process(double x) {
            for (int i = 0; i < CachedNumericalGradientLineFunction.this.N; ++i) {
                this.point[i] = CachedNumericalGradientLineFunction.this.start[i] + x * CachedNumericalGradientLineFunction.this.direction[i];
            }
            return CachedNumericalGradientLineFunction.this.function.process(this.point);
        }
    }
}

