/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.functions.SchurJacobian;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.sparse.csc.CommonOps_DSCC;

public abstract class SchurJacobian_to_NtoMxN<T extends DMatrix>
implements FunctionNtoMxN<T> {
    SchurJacobian<T> function;
    T left;
    T right;

    public SchurJacobian_to_NtoMxN(SchurJacobian<T> function) {
        this.function = function;
    }

    @Override
    public int getNumOfInputsN() {
        return this.function.getNumOfInputsN();
    }

    @Override
    public int getNumOfOutputsM() {
        return this.function.getNumOfOutputsM();
    }

    public static class DSCC
    extends SchurJacobian_to_NtoMxN<DMatrixSparseCSC> {
        public DSCC(SchurJacobian<DMatrixSparseCSC> function) {
            super(function);
            this.left = new DMatrixSparseCSC(1, 1);
            this.right = new DMatrixSparseCSC(1, 1);
        }

        @Override
        public void process(double[] input, DMatrixSparseCSC output) {
            this.function.process(input, this.left, this.right);
            CommonOps_DSCC.concatColumns((DMatrixSparseCSC)((DMatrixSparseCSC)this.left), (DMatrixSparseCSC)((DMatrixSparseCSC)this.right), (DMatrixSparseCSC)output);
        }

        @Override
        public DMatrixSparseCSC declareMatrixMxN() {
            return new DMatrixSparseCSC(this.getNumOfOutputsM(), this.getNumOfInputsN());
        }
    }

    public static class DDRM
    extends SchurJacobian_to_NtoMxN<DMatrixRMaj> {
        public DDRM(SchurJacobian<DMatrixRMaj> function) {
            super(function);
            this.left = new DMatrixRMaj(1, 1);
            this.right = new DMatrixRMaj(1, 1);
        }

        @Override
        public void process(double[] input, DMatrixRMaj output) {
            this.function.process(input, this.left, this.right);
            CommonOps_DDRM.concatColumns((DMatrixRMaj)((DMatrixRMaj)this.left), (DMatrixRMaj)((DMatrixRMaj)this.right), (DMatrixRMaj)output);
        }

        @Override
        public DMatrixRMaj declareMatrixMxN() {
            return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
        }
    }
}

