/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.rand;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class MultivariateGaussianDraw {
    private LinearSolverDense<DMatrixRMaj> solver;
    private DMatrixRMaj mean;
    private DMatrixRMaj A;
    private Random rand;
    private DMatrixRMaj r;
    private DMatrixRMaj Q_inv;
    double likelihoodLeft;

    public MultivariateGaussianDraw(Random rand, DMatrixRMaj mean, DMatrixRMaj cov) {
        this.mean = mean != null ? new DMatrixRMaj(mean) : new DMatrixRMaj(cov.numCols, 1);
        this.r = new DMatrixRMaj(cov.numRows, 1);
        this.Q_inv = new DMatrixRMaj(cov.numRows, cov.numCols);
        this.solver = LinearSolverFactory_DDRM.chol((int)cov.numRows);
        this.solver.setA((Matrix)cov);
        CholeskyDecomposition chol = (CholeskyDecomposition)this.solver.getDecomposition();
        this.A = (DMatrixRMaj)chol.getT(null);
        this.solver.invert((Matrix)this.Q_inv);
        this.likelihoodLeft = Math.pow(Math.PI * 2, (double)(-this.mean.numRows) / 2.0) * Math.sqrt(CommonOps_DDRM.det((DMatrixRMaj)cov));
        this.rand = rand;
    }

    public void assignMean(DMatrixRMaj mean) {
        this.mean = mean;
    }

    public DMatrixRMaj next(DMatrixRMaj x) {
        for (int i = 0; i < this.r.numRows; ++i) {
            this.r.set(i, 0, this.rand.nextGaussian());
        }
        x.set((DMatrixD1)this.mean);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.A, (DMatrix1Row)this.r, (DMatrix1Row)x);
        return x;
    }

    public double computeLikelihoodP() {
        double inner = VectorVectorMult_DDRM.innerProdA((DMatrixD1)this.r, (DMatrixD1)this.Q_inv, (DMatrixD1)this.r);
        return this.likelihoodLeft * Math.exp(-0.5 * inner);
    }
}

