/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FitQuadratic1D {
    LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.leastSquares((int)10, (int)3);
    DMatrixRMaj A = new DMatrixRMaj(1, 3);
    DMatrixRMaj x = new DMatrixRMaj(3, 1);
    DMatrixRMaj y = new DMatrixRMaj(1, 1);

    public boolean process(int offset, int length, double ... data) {
        if (data.length < 3) {
            throw new IllegalArgumentException("At least three points");
        }
        this.A.reshape(data.length, 3);
        this.y.reshape(data.length, 1);
        int indexDst = 0;
        int indexSrc = offset;
        for (int i = 0; i < length; ++i) {
            double d = data[indexSrc++];
            this.A.data[indexDst++] = i * i;
            this.A.data[indexDst++] = i;
            this.A.data[indexDst++] = 1.0;
            this.y.data[i] = d;
        }
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        this.solver.solve((Matrix)this.y, (Matrix)this.x);
        return true;
    }

    public double[] getCoefficients() {
        return this.x.data;
    }
}

