/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ddogleg.solver.impl.RootFinderCompanion;
import org.ddogleg.solver.impl.WrapRealRootsSturm;
import org.ejml.data.Complex_F64;
import org.ejml.ops.ComplexMath_F64;

public class PolynomialSolver {
    public static PolynomialRoots createRootFinder(RootFinderType type, int maxDegree) {
        switch (type) {
            case EVD: {
                return new RootFinderCompanion();
            }
            case STURM: {
                FindRealRootsSturm sturm = new FindRealRootsSturm(maxDegree, -1.0, 1.0E-10, 30, 20);
                return new WrapRealRootsSturm(sturm);
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public static Complex_F64[] polynomialRootsEVD(double ... coefficients) {
        RootFinderCompanion alg = new RootFinderCompanion();
        if (!alg.process(Polynomial.wrap(coefficients))) {
            throw new IllegalArgumentException("Algorithm failed, was the input bad?");
        }
        List<Complex_F64> coefs = alg.getRoots();
        return coefs.toArray(new Complex_F64[0]);
    }

    public static double cubicRootReal(double a, double b, double c, double d) {
        double temp;
        double insideLeft;
        double insideOfSqrt;
        double norm = Math.max(Math.abs(a), Math.abs(b));
        norm = Math.max(norm, Math.abs(c));
        if ((insideOfSqrt = (insideLeft = 2.0 * (c /= (norm = Math.max(norm, Math.abs(d)))) * c * c - 9.0 * (d /= norm) * c * (b /= norm) + 27.0 * d * d * (a /= norm)) * insideLeft - 4.0 * (temp = c * c - 3.0 * d * b) * temp * temp) >= 0.0) {
            double insideRight = Math.sqrt(insideOfSqrt);
            double ret = c + PolynomialSolver.root3(0.5 * (insideLeft + insideRight)) + PolynomialSolver.root3(0.5 * (insideLeft - insideRight));
            return -ret / (3.0 * d);
        }
        Complex_F64 inside = new Complex_F64(0.5 * insideLeft, 0.5 * Math.sqrt(-insideOfSqrt));
        Complex_F64 root = new Complex_F64();
        ComplexMath_F64.root((Complex_F64)inside, (int)3, (int)2, (Complex_F64)root);
        double ret = c + 2.0 * root.getReal();
        return -ret / (3.0 * d);
    }

    private static double root3(double val) {
        if (val < 0.0) {
            return -Math.pow(-val, 0.3333333333333333);
        }
        return Math.pow(val, 0.3333333333333333);
    }

    public static double cubicDiscriminant(double a, double b, double c, double d) {
        return 18.0 * d * c * b * a - 4.0 * c * c * c * a + c * c * b * b - 4.0 * d * b * b * b - 27.0 * d * d * a * a;
    }
}

