/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

public class CircularQueue_F64 {
    public double[] data;
    public int start;
    public int size;

    public CircularQueue_F64() {
        this(10);
    }

    public CircularQueue_F64(int dataSize) {
        this.data = new double[dataSize];
    }

    public void reset() {
        this.size = 0;
        this.start = 0;
    }

    public double popHead() {
        double r = this.data[this.start];
        this.removeHead();
        return r;
    }

    public double popTail() {
        double r = this.tail();
        this.removeTail();
        return r;
    }

    public double head() {
        return this.data[this.start];
    }

    public double tail() {
        return this.data[(this.start + this.size - 1) % this.data.length];
    }

    public void removeHead() {
        this.start = (this.start + 1) % this.data.length;
        --this.size;
    }

    public void removeTail() {
        --this.size;
    }

    public double get(int index) {
        return this.data[(this.start + index) % this.data.length];
    }

    public void add(double value) {
        if (this.size >= this.data.length) {
            this.data[this.start] = value;
            this.start = (this.start + 1) % this.data.length;
        } else {
            this.data[(this.start + this.size) % this.data.length] = value;
            ++this.size;
        }
    }

    private int nextDataSize() {
        if (this.data.length < 1000) {
            return this.data.length * 2;
        }
        if (this.data.length < 10000) {
            return this.data.length * 3 / 2;
        }
        return this.data.length * 6 / 5;
    }

    public void set(CircularQueue_F64 original) {
        if (this.data.length != original.data.length) {
            this.data = new double[original.data.length];
        }
        System.arraycopy(original.data, 0, this.data, 0, this.data.length);
        this.size = original.size;
        this.start = original.start;
    }

    public CircularQueue_F64 copy() {
        CircularQueue_F64 r = new CircularQueue_F64();
        r.set(this);
        return r;
    }

    public void resizeQueue(int maxSize) {
        if (this.data.length != maxSize) {
            this.data = new double[maxSize];
        }
    }

    public int queueSize() {
        return this.data.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }
}

