/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueueList;

public class FastQueue<T>
implements Serializable {
    public T[] data;
    public int size;
    public Class<T> type;
    private Factory<T> factory;
    private FastQueueList<T> list = new FastQueueList(this);

    public FastQueue(int initialMaxSize, Class<T> type, boolean declareInstances) {
        this.init(initialMaxSize, type, declareInstances ? new FactoryClass(type) : null);
    }

    public FastQueue(Class<T> type, boolean declareInstances) {
        this.init(10, type, declareInstances ? new FactoryClass(type) : null);
    }

    public FastQueue(Class<T> type, Factory<T> factory) {
        this.init(10, type, factory);
    }

    public FastQueue(int initialMaxSize, Class<T> type, Factory<T> factory) {
        this.init(initialMaxSize, type, factory);
    }

    protected FastQueue() {
    }

    protected void init(int initialMaxSize, Class<T> type, Factory<T> factory) {
        this.size = 0;
        this.type = type;
        this.factory = factory;
        this.data = (Object[])Array.newInstance(type, initialMaxSize);
        if (factory != null) {
            for (int i = 0; i < initialMaxSize; ++i) {
                try {
                    this.data[i] = this.createInstance();
                    continue;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("declareInstances is true, but createInstance() can't create a new instance.  Maybe override createInstance()?");
                }
            }
        }
    }

    public List<T> toList() {
        return this.list;
    }

    public T removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new IllegalArgumentException("Size is already zero");
    }

    public T getTail() {
        return this.data[this.size - 1];
    }

    public T getTail(int index) {
        return this.data[this.size - 1 - index];
    }

    public void reset() {
        this.size = 0;
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public int size() {
        return this.size;
    }

    public void reverse() {
        for (int i = 0; i < this.size / 2; ++i) {
            T tmp = this.data[i];
            this.data[i] = this.data[this.size - i - 1];
            this.data[this.size - i - 1] = tmp;
        }
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("Index out of bounds: index " + index + " size " + this.size);
        }
        return this.data[index];
    }

    public T grow() {
        if (this.size < this.data.length) {
            return this.data[this.size++];
        }
        this.growArray((this.data.length + 1) * 2);
        return this.data[this.size++];
    }

    public void remove(int index) {
        T removed = this.data[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        this.data[this.size - 1] = removed;
        --this.size;
    }

    public void add(T object) {
        if (this.size >= this.data.length) {
            this.growArray((this.data.length + 1) * 2);
        }
        this.data[this.size++] = object;
    }

    public void addAll(FastQueue<T> list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.data[i]);
        }
    }

    public void add(T[] array, int first, int length) {
        for (int i = 0; i < length; ++i) {
            this.add(array[first + i]);
        }
    }

    public void growArray(int length) {
        if (this.data.length >= length) {
            return;
        }
        Object[] data = (Object[])Array.newInstance(this.type, length);
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        if (this.factory != null) {
            for (int i = this.data.length; i < length; ++i) {
                data[i] = this.createInstance();
            }
        }
        this.data = data;
    }

    public void resize(int length) {
        this.growArray(length);
        this.size = length;
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected T createInstance() {
        return this.factory.newInstance();
    }

    public List<T> copyIntoList(List<T> ret) {
        if (ret == null) {
            ret = new ArrayList<T>(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            ret.add(this.data[i]);
        }
        return ret;
    }

    public int indexOf(T obj) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public T[] getData() {
        return this.data;
    }

    public void setData(T[] data) {
        this.data = data;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isDeclareInstances() {
        return this.factory != null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public class FactoryClass<T>
    implements Factory<T> {
        Class type;

        public FactoryClass(Class type) {
            this.type = type;
        }

        @Override
        public T newInstance() {
            try {
                return this.type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Factory<T> {
        public T newInstance();
    }
}

