/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.GrowQueue;

public class GrowQueue_B
implements GrowQueue<GrowQueue_B> {
    public boolean[] data;
    public int size;

    public GrowQueue_B(int maxSize) {
        this.data = new boolean[maxSize];
        this.size = 0;
    }

    public GrowQueue_B() {
        this(10);
    }

    public static GrowQueue_B zeros(int length) {
        GrowQueue_B out = new GrowQueue_B(length);
        out.size = length;
        return out;
    }

    public static GrowQueue_B array(boolean ... values) {
        GrowQueue_B out = GrowQueue_B.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static GrowQueue_B array(int ... values) {
        GrowQueue_B out = GrowQueue_B.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i] != 0;
        }
        return out;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void add(boolean value) {
        this.push(value);
    }

    public void push(boolean val) {
        if (this.size == this.data.length) {
            boolean[] temp = new boolean[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public boolean unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(GrowQueue_B original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void fill(boolean value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void insert(int index, boolean value) {
        if (this.size == this.data.length) {
            boolean[] temp = new boolean[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public boolean removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last");
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size");
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    @Override
    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new boolean[size];
        }
        this.size = size;
    }

    @Override
    public void extend(int size) {
        if (this.data.length < size) {
            boolean[] tmp = new boolean[size];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
        this.size = size;
    }

    @Override
    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new boolean[size];
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, false);
    }

    @Override
    public GrowQueue_B copy() {
        GrowQueue_B ret = new GrowQueue_B(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D) {
            boolean tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public boolean pop() {
        return this.data[--this.size];
    }

    public int indexOf(boolean value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        throw new RuntimeException("Undefined for boolean");
    }
}

