/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.GrowQueue;

public class GrowQueue_F32
implements GrowQueue<GrowQueue_F32> {
    public float[] data;
    public int size;

    public GrowQueue_F32(int maxSize) {
        this.data = new float[maxSize];
        this.size = 0;
    }

    public GrowQueue_F32() {
        this(10);
    }

    public static GrowQueue_F32 zeros(int length) {
        GrowQueue_F32 out = new GrowQueue_F32(length);
        out.size = length;
        return out;
    }

    public static GrowQueue_F32 array(float ... values) {
        GrowQueue_F32 out = GrowQueue_F32.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_F32 queue) {
        if (this.size + queue.size > this.data.length) {
            float[] temp = new float[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(float[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            float[] temp = new float[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(float val) {
        this.push(val);
    }

    public void push(float val) {
        if (this.size == this.data.length) {
            float[] temp = new float[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void setTo(float[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last");
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size");
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, float value) {
        if (this.size == this.data.length) {
            float[] temp = new float[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public float removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public float get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public float getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public float unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, float value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(GrowQueue_F32 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void fill(float value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public boolean contains(float value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new float[size];
        }
        this.size = size;
    }

    @Override
    public void extend(int size) {
        if (this.data.length < size) {
            float[] tmp = new float[size];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
        this.size = size;
    }

    @Override
    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new float[size];
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, 0.0f);
    }

    @Override
    public GrowQueue_F32 copy() {
        GrowQueue_F32 ret = new GrowQueue_F32(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D) {
            float tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public float pop() {
        return this.data[--this.size];
    }

    public int indexOf(float value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfGreatest() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        float best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] > best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    public int indexOfLeast() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        float best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] < best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }
}

