/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.List;
import java.util.Stack;

public class LinkedList<T> {
    Element<T> first;
    Element<T> last;
    int size;
    Stack<Element<T>> available = new Stack();

    public void reset() {
        Element<T> e = this.first;
        while (e != null) {
            Element n = e.next;
            e.clear();
            this.available.add(e);
            e = n;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Element<T> getElement(int index, boolean fromFront) {
        if (index > this.size || index < 0) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        if (fromFront) {
            Element<T> e = this.first;
            for (int i = 0; i < index; ++i) {
                e = e.next;
            }
            return e;
        }
        Element<T> e = this.last;
        for (int i = 0; i < index; ++i) {
            e = e.previous;
        }
        return e;
    }

    public Element<T> pushHead(T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        if (this.first == null) {
            this.last = e;
            this.first = this.last;
        } else {
            e.next = this.first;
            this.first.previous = e;
            this.first = e;
        }
        ++this.size;
        return e;
    }

    public Element<T> pushTail(T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        if (this.last == null) {
            this.last = e;
            this.first = this.last;
        } else {
            e.previous = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
        return e;
    }

    public Element<T> insertAfter(Element<T> previous, T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        e.previous = previous;
        e.next = previous.next;
        if (e.next != null) {
            e.next.previous = e;
        } else {
            this.last = e;
        }
        previous.next = e;
        ++this.size;
        return e;
    }

    public Element<T> insertBefore(Element<T> next, T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        e.previous = next.previous;
        e.next = next;
        if (e.previous != null) {
            e.previous.next = e;
        } else {
            this.first = e;
        }
        next.previous = e;
        ++this.size;
        return e;
    }

    public void swap(Element<T> a, Element<T> b) {
        if (a.next == b) {
            if (a.previous != null) {
                a.previous.next = b;
            }
            if (b.next != null) {
                b.next.previous = a;
            }
            Element tmp = a.previous;
            a.previous = b;
            a.next = b.next;
            b.previous = tmp;
            b.next = a;
            if (this.first == a) {
                this.first = b;
            }
            if (this.last == b) {
                this.last = a;
            }
        } else if (a.previous == b) {
            if (a.next != null) {
                a.next.previous = b;
            }
            if (b.previous != null) {
                b.previous.next = a;
            }
            Element tmp = a.next;
            a.next = b;
            a.previous = b.previous;
            b.previous = a;
            b.next = tmp;
            if (this.first == b) {
                this.first = a;
            }
            if (this.last == a) {
                this.last = b;
            }
        } else {
            if (a.next != null) {
                a.next.previous = b;
            }
            if (a.previous != null) {
                a.previous.next = b;
            }
            if (b.next != null) {
                b.next.previous = a;
            }
            if (b.previous != null) {
                b.previous.next = a;
            }
            Element tempNext = b.next;
            Element tempPrev = b.previous;
            b.next = a.next;
            b.previous = a.previous;
            a.next = tempNext;
            a.previous = tempPrev;
            if (a.next == null) {
                this.last = a;
            } else if (b.next == null) {
                this.last = b;
            }
            if (a.previous == null) {
                this.first = a;
            } else if (b.previous == null) {
                this.first = b;
            }
        }
    }

    public void remove(Element<T> element) {
        if (element.next == null) {
            this.last = element.previous;
        } else {
            element.next.previous = element.previous;
        }
        if (element.previous == null) {
            this.first = element.next;
        } else {
            element.previous.next = element.next;
        }
        --this.size;
        element.clear();
        this.available.push(element);
    }

    public T removeHead() {
        if (this.first == null) {
            throw new IllegalArgumentException("Empty list");
        }
        T ret = this.first.getObject();
        Element<T> e = this.first;
        this.available.push(this.first);
        if (this.first.next != null) {
            this.first.next.previous = null;
            this.first = this.first.next;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    public Object removeTail() {
        if (this.last == null) {
            throw new IllegalArgumentException("Empty list");
        }
        T ret = this.last.getObject();
        Element<T> e = this.last;
        this.available.add(this.last);
        if (this.last.previous != null) {
            this.last.previous.next = null;
            this.last = this.last.previous;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    public Element<T> find(T object) {
        Element<T> e = this.first;
        while (e != null) {
            if (e.object == object) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Element<T> getHead() {
        return this.first;
    }

    public Element<T> getTail() {
        return this.last;
    }

    public void addAll(List<T> list) {
        if (list.isEmpty()) {
            return;
        }
        Element<T> a = this.requestNew();
        a.object = list.get(0);
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.previous = this.last;
        }
        for (int i = 1; i < list.size(); ++i) {
            Element<T> b = this.requestNew();
            b.object = list.get(i);
            a.next = b;
            b.previous = a;
            a = b;
        }
        this.last = a;
        this.size += list.size();
    }

    public void addAll(T[] array, int first, int length) {
        if (length <= 0) {
            return;
        }
        Element<T> a = this.requestNew();
        a.object = array[first];
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.previous = this.last;
        }
        for (int i = 1; i < length; ++i) {
            Element<T> b = this.requestNew();
            b.object = array[first + i];
            a.next = b;
            b.previous = a;
            a = b;
        }
        this.last = a;
        this.size += length;
    }

    public int size() {
        return this.size;
    }

    protected Element<T> requestNew() {
        if (this.available.isEmpty()) {
            return new Element();
        }
        return this.available.pop();
    }

    public static class Element<T> {
        public Element<T> next;
        public Element<T> previous;
        public T object;

        public void clear() {
            this.next = null;
            this.previous = null;
            this.object = null;
        }

        public Element getNext() {
            return this.next;
        }

        public void setNext(Element<T> next) {
            this.next = next;
        }

        public Element getPrevious() {
            return this.previous;
        }

        public void setPrevious(Element<T> previous) {
            this.previous = previous;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

