/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class BiometricImageTransformation {
    public static final String pathSeparator = new String(System.getProperty("file.separator"));
    public static final Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.BiometricImageTransformation.class");
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    public static File getFlippedFile(File input) throws Exception {
        File output = null;
        String path = input.getParent();
        String filename = input.getName();
        String ext = BiometricImageTransformation.getExtFromFilename(filename);
        filename = (filename = filename.replace(ext, "flipped." + ext)).contains("left") ? filename.replace("left", "right") : filename.replace("right", "left");
        output = new File(path + pathSeparator + filename);
        LOG.info((Object)("Changed filename from \"" + input.getAbsolutePath() + "\" to \"" + output.getAbsolutePath() + "\""));
        return output;
    }

    public static String getExtFromFilename(String filename) {
        String output = filename.substring(filename.lastIndexOf(".") + 1);
        return output;
    }

    public static String getFormatNameFromExtension(String ext) {
        if (ext.equalsIgnoreCase("tif")) {
            return "tif";
        }
        if (ext.equalsIgnoreCase("jpeg")) {
            return "jpeg";
        }
        if (ext.equalsIgnoreCase("pbm")) {
            return "pnm";
        }
        if (ext.equalsIgnoreCase("bmp")) {
            return "bmp";
        }
        if (ext.equalsIgnoreCase("jpg")) {
            return "jpg";
        }
        if (ext.equalsIgnoreCase("wbmp")) {
            return "wbmp";
        }
        if (ext.equalsIgnoreCase("ppm")) {
            return "pnm";
        }
        if (ext.equalsIgnoreCase("png")) {
            return "png";
        }
        if (ext.equalsIgnoreCase("jp2")) {
            return "jpeg2000";
        }
        if (ext.equalsIgnoreCase("pgm")) {
            return "pnm";
        }
        if (ext.equalsIgnoreCase("gif")) {
            return "gif";
        }
        if (ext.equalsIgnoreCase("tiff")) {
            return "tiff";
        }
        return "";
    }

    public static BufferedImage rotate(BufferedImage img, int angle) throws Exception {
        if (img == null) {
            LOG.error((Object)"Cannot process null image!");
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawImage(img, null, 0, 0);
        return dimg;
    }

    public static BufferedImage flipHorizontal(BufferedImage img) {
        return BiometricImageTransformation.flip(img, 1);
    }

    public static BufferedImage flipVertical(BufferedImage img) {
        return BiometricImageTransformation.flip(img, 2);
    }

    public static BufferedImage flip(BufferedImage img, int direction) {
        BufferedImage output = null;
        AffineTransform tx = null;
        switch (direction) {
            case 1: {
                tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                tx.translate(-img.getWidth(null), 0.0);
                break;
            }
            default: {
                tx = AffineTransform.getScaleInstance(1.0, -1.0);
                tx.translate(0.0, -img.getHeight(null));
            }
        }
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        output = op.filter(img, null);
        return output;
    }

    public static void rotateWriteImage(File input, File output) throws Exception {
        BiometricImageTransformation.rotateWriteImage(input, output, "jp2", 180);
    }

    public static void rotateWriteImage(File input, File output, String form) throws Exception {
        BiometricImageTransformation.rotateWriteImage(input, output, form, 180);
    }

    public static void rotateWriteImage(File input, File output, String form, int angle) throws Exception {
        BufferedImage buff_img = ImageIO.read(input);
        LOG.info((Object)("Read: \"" + buff_img.toString() + "\""));
        BufferedImage rot_img = BiometricImageTransformation.rotate(buff_img, angle);
        LOG.info((Object)("After rotation: \"" + rot_img.toString() + "\""));
        String format_name = BiometricImageTransformation.getFormatNameFromExtension(form);
        LOG.info((Object)("Writing file with ext \"" + form + "\" as format \"" + format_name + "\""));
        ImageIO.write((RenderedImage)rot_img, format_name, output);
    }

    public static void flipWriteImage(File input, File output) throws Exception {
        BiometricImageTransformation.flipWriteImage(input, output, "jp2", 2);
    }

    public static void flipWriteImage(File input, File output, String form) throws Exception {
        BiometricImageTransformation.flipWriteImage(input, output, form, 2);
    }

    public static void flipWriteImage(File input, File output, String form, int direction) throws Exception {
        BufferedImage buff_img = ImageIO.read(input);
        LOG.info((Object)("Read: \"" + buff_img.toString() + "\""));
        BufferedImage rot_img = BiometricImageTransformation.flip(buff_img, direction);
        LOG.info((Object)("After flip: \"" + rot_img.toString() + "\""));
        String format_name = BiometricImageTransformation.getFormatNameFromExtension(form);
        LOG.info((Object)("Writing file with ext \"" + form + "\" as format \"" + format_name + "\""));
        ImageIO.write((RenderedImage)rot_img, format_name, output);
    }

    public static byte[] rotateImage(byte[] input) throws Exception {
        return BiometricImageTransformation.rotateImage(input, "jp2", 180);
    }

    public static byte[] rotateImage(byte[] input, String form) throws Exception {
        return BiometricImageTransformation.rotateImage(input, form, 180);
    }

    public static byte[] rotateImage(byte[] input, String form, int angle) throws Exception {
        LOG.info((Object)("Rotating image of size=" + input.length + " form=" + form + " by angle=" + angle));
        byte[] output = null;
        BufferedImage buff_img = ImageIO.read(new ByteArrayInputStream(input));
        LOG.info((Object)("Read: \"" + buff_img.toString() + "\""));
        BufferedImage rot_img = BiometricImageTransformation.rotate(buff_img, angle);
        LOG.info((Object)("After rotation: \"" + rot_img.toString() + "\""));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String format_name = BiometricImageTransformation.getFormatNameFromExtension(form);
        LOG.info((Object)("Writing file with ext \"" + form + "\" as format \"" + format_name + "\""));
        ImageIO.write((RenderedImage)rot_img, format_name, baos);
        output = baos.toByteArray();
        return output;
    }

    public static byte[] flipImage(byte[] input) throws Exception {
        return BiometricImageTransformation.flipImage(input, "jp2", 180);
    }

    public static byte[] flipImage(byte[] input, String form) throws Exception {
        return BiometricImageTransformation.flipImage(input, form, 180);
    }

    public static byte[] flipImage(byte[] input, String form, int direction) throws Exception {
        LOG.info((Object)("Fipping image of size=" + input.length + " form=" + form + " by dir=" + direction));
        byte[] output = null;
        BufferedImage buff_img = ImageIO.read(new ByteArrayInputStream(input));
        LOG.info((Object)("Read: \"" + buff_img.toString() + "\""));
        BufferedImage rot_img = BiometricImageTransformation.flip(buff_img, direction);
        LOG.info((Object)("After flip: \"" + rot_img.toString() + "\""));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String format_name = BiometricImageTransformation.getFormatNameFromExtension(form);
        LOG.info((Object)("Writing file with ext \"" + form + "\" as format \"" + format_name + "\""));
        ImageIO.write((RenderedImage)rot_img, format_name, baos);
        output = baos.toByteArray();
        return output;
    }

    public static void usage() {
        System.out.println("UIDAI Image Transformer");
        System.out.println("Usage:");
        System.out.println("  <file list> | java com.identix.uidai.cbeff.BiometricImageTransformation <arg?>");
        System.out.println("  Take list of files to process and pass in through STDIN");
        System.out.println("  with single optional argument specifying operation to perform.");
        System.out.println("  <arg>: ");
        System.out.println("     --help = Print this message and exit.");
        System.out.println("     -r     = (OPT) Rotate images 180 degrees. (Default Operation)");
        System.out.println("     -fh    = (OPT) Flip images horizontally.");
        System.out.println("     -fv    = (OPT) Flip images vertically.");
    }

    public static void main(String[] args) {
        String[] readers;
        if (args.length > 0 && args[0].equalsIgnoreCase("--help") || args.length > 1) {
            BiometricImageTransformation.usage();
            System.exit(-9);
        }
        Logger MAIN_LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.BiometricImageTransformation.class");
        String readers_str = new String("Readers(");
        for (String reader : readers = ImageIO.getReaderFormatNames()) {
            readers_str = readers_str + reader + ":";
        }
        readers_str = readers_str + ")";
        MAIN_LOG.info((Object)readers_str);
        readers_str = new String("ReaderExtensions(");
        for (String reader : readers = ImageIO.getReaderFileSuffixes()) {
            readers_str = readers_str + reader + ":";
        }
        readers_str = readers_str + ")";
        MAIN_LOG.info((Object)readers_str);
        try {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String fname = null;
            File input_file = null;
            File new_file = null;
            fname = stdin.readLine();
            while (fname != null) {
                MAIN_LOG.info((Object)("Attempting to read file \"" + fname + "\" at " + new Date().getTime()));
                try {
                    input_file = new File(fname);
                    new_file = BiometricImageTransformation.getFlippedFile(input_file);
                    if (args.length == 1) {
                        if (args[0].equalsIgnoreCase("-fh")) {
                            BiometricImageTransformation.flipWriteImage(input_file, new_file, BiometricImageTransformation.getExtFromFilename(fname), 1);
                        } else if (args[0].equalsIgnoreCase("-fv")) {
                            BiometricImageTransformation.flipWriteImage(input_file, new_file, BiometricImageTransformation.getExtFromFilename(fname), 2);
                        } else if (args[0].equalsIgnoreCase("-r")) {
                            BiometricImageTransformation.rotateWriteImage(input_file, new_file, BiometricImageTransformation.getExtFromFilename(fname), 180);
                        } else {
                            BiometricImageTransformation.usage();
                            System.exit(-9);
                        }
                    } else {
                        BiometricImageTransformation.rotateWriteImage(input_file, new_file, BiometricImageTransformation.getExtFromFilename(fname), 180);
                    }
                    boolean succ = input_file.delete();
                    if (succ) {
                        MAIN_LOG.info((Object)("Completed processing input file \"" + input_file.getAbsolutePath() + "\"."));
                    } else {
                        MAIN_LOG.error((Object)("Failed to remove original image file \"" + input_file.getAbsolutePath() + "\"!"));
                    }
                }
                catch (Exception e) {
                    MAIN_LOG.error((Object)("Processing of imagefile \"" + fname + "\" failed!"), (Throwable)e);
                }
                fname = stdin.readLine();
            }
        }
        catch (Exception e) {
            MAIN_LOG.error((Object)"Failed to process input from STDIN!", (Throwable)e);
            System.exit(-1);
        }
    }
}

