/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai;

import com.identix.event.InterruptEvent;
import com.identix.event.InterruptListener;
import com.identix.event.Interruptor;
import com.identix.event.WorkCompleteEvent;
import com.identix.event.WorkCompleteListener;
import com.identix.event.Worker;
import com.identix.uidai.cbeff.CBEFF;
import com.identix.uidai.cbeff.UIDAICBEFFDirectoryProcessor;
import com.identix.util.Queue;
import com.identix.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBEFFGen
extends Interruptor
implements WorkCompleteListener {
    private Properties _sysprops = System.getProperties();
    private Properties _cbeffgenprops = null;
    private String _propsFile = new String("etc/cbeffgen.properties");
    private boolean _running = false;
    private final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    private final Logger LOG_OUT = Logger.getLogger((String)"output");
    private long _start_time = 0L;
    private long _end_time = 0L;
    private String _output = new String("output");
    private Queue<String> _daQueue = new Queue();
    private Vector<CBEFFGenerator> _workers = new Vector();
    private int cbeff_ct = 0;
    private int _threads = 1;
    private int _batch_size = 1;
    private int _wait = 1000;
    private final SimpleDateFormat _format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public String toString() {
        String output = new String("System properties read from " + this._propsFile + "\n");
        return output;
    }

    public CBEFFGen() {
        this(null);
    }

    public CBEFFGen(String propsFile) {
        try {
            this.register("INT");
        }
        catch (Exception e) {
            this.LOG.fatal((Object)"Failed to register SIGINT handler!", (Throwable)e);
            System.exit(-5);
        }
        this.LOG.info((Object)"UIDAI CBEFFGen");
        this.LOG.info((Object)"Initializing..");
        if (propsFile != null && !propsFile.equals("")) {
            this._propsFile = new String(propsFile);
        }
        try {
            this._cbeffgenprops = new Properties();
            this._cbeffgenprops.load(new FileInputStream(this._propsFile));
        }
        catch (Exception e) {
            this.LOG.fatal((Object)("Read from cbeffgen config '" + this._propsFile + "' failed: " + e.toString()), (Throwable)e);
            System.exit(-2);
        }
        this.parseProperties();
        this.LOG.info((Object)("Initialized with properties file '" + this._propsFile + "' "));
        this.LOG.info((Object)this.toString());
    }

    private void parseProperties() {
        this.LOG.info((Object)"Parsing cbeffgen.properties..");
        String tmp_output = this._cbeffgenprops.getProperty("output");
        if (tmp_output != null && !tmp_output.equals("")) {
            this.setOutput(tmp_output);
        } else {
            this.setOutput("output");
        }
        String tmp_threads = this._cbeffgenprops.getProperty("threads");
        try {
            this._threads = new Integer(tmp_threads);
        }
        catch (Exception e) {
            this._threads = 1;
        }
        String tmp_batch_size = this._cbeffgenprops.getProperty("batch_size");
        try {
            this._batch_size = new Integer(tmp_batch_size);
        }
        catch (Exception e) {
            this._batch_size = 1;
        }
        String tmp_wait = this._cbeffgenprops.getProperty("wait");
        try {
            this._wait = new Integer(tmp_wait);
        }
        catch (Exception e) {
            this._wait = 1000;
        }
    }

    public void setOutput(String path) {
        this._output = new String(path);
        try {
            File tmp_fl = new File(this._output);
            tmp_fl.mkdirs();
        }
        catch (Exception e) {
            this.LOG.fatal((Object)"Output directory failed to be utilized!", (Throwable)e);
            System.exit(-4);
        }
    }

    public void logStartupStatus() {
        this._start_time = System.currentTimeMillis();
        this.LOG.error((Object)("Beginning the CBEFF generation process at: " + new Date(this._start_time).toString()));
    }

    public void logClosingStatus(int count) {
        this._end_time = System.currentTimeMillis();
        this.LOG.error((Object)("Ending the CBEFF generation process at: " + new Date(this._end_time).toString()));
        this.LOG.error((Object)("" + count + " CBEFF files generated."));
        long elapse = this._end_time - this._start_time;
        this.LOG.error((Object)("Time Elapsed: " + Utility.getElapsedString(elapse)));
    }

    public void processOne(String path) {
        this.logStartupStatus();
        this._running = true;
        try {
            File tmp_fl = new File(path);
            String name = tmp_fl.getName();
            UIDAICBEFFDirectoryProcessor tmp_proc = new UIDAICBEFFDirectoryProcessor();
            Vector<String> tmp_data = tmp_proc.processFolder(new File(path));
            CBEFF tmp_cbeff = new CBEFF(tmp_data);
            Utility.writeStringToFile(tmp_cbeff.toCBEFFString(), this._output, name + ".xml");
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failure in CBEFF file generation!", (Throwable)e);
        }
        this.logClosingStatus(1);
        System.exit(0);
    }

    public void processOneGP(String path) {
        this.logStartupStatus();
        this._running = true;
        try {
            File tmp_fl = new File(path);
            String name = tmp_fl.getName();
            UIDAICBEFFDirectoryProcessor tmp_proc = new UIDAICBEFFDirectoryProcessor();
            Vector<String> tmp_data = tmp_proc.processFolder(new File(path));
            CBEFF tmp_cbeff = new CBEFF(tmp_data);
            Utility.writeStringToFile(tmp_cbeff.toStringGP(), this._output, name + ".xml");
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failure in CBEFF file generation!", (Throwable)e);
        }
        this.logClosingStatus(1);
        System.exit(0);
    }

    public void processMany(String path) {
        this.logStartupStatus();
        this._running = true;
        this.cbeff_ct = 0;
        try {
            int i;
            UIDAICBEFFDirectoryProcessor tmp_proc = new UIDAICBEFFDirectoryProcessor(path);
            Hashtable<String, Vector<String>> tmp_out = tmp_proc.process();
            Enumeration<String> keys = tmp_out.keys();
            this._daQueue.push(keys);
            this.LOG.info((Object)("Processing " + this._daQueue.size() + " CBEFFs..."));
            for (i = 0; i < this._threads; ++i) {
                CBEFFGenerator tmp_th = new CBEFFGenerator(this._daQueue, tmp_out);
                this.addInterruptListener(tmp_th);
                tmp_th.addWorkCompleteListener(this);
                this._workers.add(tmp_th);
                this.LOG.info((Object)("Creating thread " + (i + 1)));
            }
            for (i = 0; i < this._workers.size(); ++i) {
                this.LOG.info((Object)("Starting thread " + (i + 1)));
                this._workers.elementAt(i).start();
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failure in CBEFF file generation!", (Throwable)e);
        }
    }

    @Override
    public boolean handle(String signame) {
        this.LOG.info((Object)(signame + " Captured!"));
        this._running = false;
        this.fireInterrupt(this, signame);
        System.exit(-9);
        return true;
    }

    public static void usage() {
        System.out.println("UIDAI CBEFF Generator");
        System.out.println("Usage:");
        System.out.println("  java com.identix.uidai.CBEFFGen <args?>");
        System.out.println("  <args>: ");
        System.out.println("  --help            = Shows this helpful message.");
        System.out.println("  -c <filename?>    = (OPT) The location of the cbeffgen properties file.");
        System.out.println("       Default: <install_path>\\etc\\cbeffgen.properties");
        System.out.println("  -d <dirname>      = (OPT) The location of the properly formatted and named");
        System.out.println("                      single directory of biometrics.");
        System.out.println("                      **Uses String-based XML generation.");
        System.out.println("  -dgp <dirname>    = (OPT) The location of the properly formatted and named");
        System.out.println("                      single directory of biometrics.");
        System.out.println("                      **Uses GenParser-based XML generation.");
        System.out.println("  -D <dirname>      = (OPT) The location of the properly formatted and named");
        System.out.println("                      directory of directories of biometrics.");
        System.out.println("  -o <dirname>      = (OPT) The location to place output files.");
        System.out.println("     *** A -c must be first argument if present.");
        System.out.println("     *** One of -d, -dgp or -D must be present.");
    }

    public synchronized Queue<String> getNextBatch() {
        Queue<String> output = new Queue<String>();
        for (int i = 0; i < this._batch_size && this._daQueue.size() > 0; ++i) {
            output.push(this._daQueue.pop());
        }
        return output;
    }

    @Override
    public synchronized void workComplete(WorkCompleteEvent wce) {
        Object caller = wce.getSource();
        this.cbeff_ct += ((CBEFFGenerator)caller).getCount();
        Queue<String> tmp_q = this.getNextBatch();
        if (tmp_q.size() > 0) {
            this.LOG.info((Object)("Queuing " + tmp_q.size() + " more jobs for processing..."));
            ((CBEFFGenerator)caller).queueJobs(tmp_q);
        } else {
            this._workers.remove(caller);
            if (this._workers.size() < 1) {
                this.LOG.info((Object)"Last thread complete!");
                this.logClosingStatus(this.cbeff_ct);
                System.exit(0);
            } else {
                this.LOG.info((Object)"1 Thread complete!");
            }
        }
    }

    public static void main(String[] args) {
        CBEFFGen cbeffgen = null;
        if (args.length == 1 && args[0].trim().equalsIgnoreCase("--help")) {
            CBEFFGen.usage();
            System.exit(0);
        } else if (args.length == 2 && args[0].equalsIgnoreCase("-c") || args.length == 0 || args.length % 2 != 0) {
            CBEFFGen.usage();
            System.exit(0);
        } else if (args.length >= 2) {
            String tmp_config = null;
            String tmp_dir = null;
            String tmp_dir_gp = null;
            String tmp_big_dir = null;
            String tmp_out = null;
            for (int i = 0; i < args.length; i += 2) {
                if (args[i].equals("-c")) {
                    tmp_config = new String(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-D")) {
                    tmp_big_dir = new String(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    tmp_dir = new String(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-dgp")) {
                    tmp_dir_gp = new String(args[i + 1]);
                    continue;
                }
                if (!args[i].equals("-o")) continue;
                tmp_out = new String(args[i + 1]);
            }
            if (tmp_dir == null && tmp_big_dir == null && tmp_dir_gp == null) {
                System.out.println("Invalid arguments passed to cbeffgen!  You must include either -d, -dgp or -D!");
                CBEFFGen.usage();
                System.exit(-1);
            }
            cbeffgen = tmp_config != null ? new CBEFFGen(tmp_config) : new CBEFFGen();
            if (tmp_out != null) {
                cbeffgen.setOutput(tmp_out);
            }
            if (tmp_big_dir != null) {
                cbeffgen.processMany(tmp_big_dir);
            } else if (tmp_dir_gp != null) {
                cbeffgen.processOneGP(tmp_dir_gp);
            } else {
                cbeffgen.processOne(tmp_dir);
            }
        } else {
            System.out.println("Invalid arguments passed to cbeffgen!");
            CBEFFGen.usage();
            System.exit(-1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CBEFFGenerator
    extends Worker
    implements InterruptListener {
        private Queue<String> myqueue = null;
        private Hashtable<String, Vector<String>> mydata = null;
        private int _mycount = 0;
        private boolean _inner_running = false;
        private boolean _waiting = false;

        public CBEFFGenerator(Queue<String> daQueue, Hashtable<String, Vector<String>> data) {
            this.myqueue = daQueue;
            this.mydata = data;
        }

        public void queueJobs(Queue<String> input) {
            while (input.size() > 0) {
                this.myqueue.push(input.pop());
            }
            this._mycount = 0;
            this._waiting = false;
        }

        @Override
        public void run() {
            this._inner_running = true;
            while (this._inner_running) {
                while (this._waiting) {
                    try {
                        Thread.sleep(CBEFFGen.this._wait);
                    }
                    catch (Exception ie) {}
                }
                String name = this.myqueue.pop();
                if (name != null) {
                    Vector<String> tmp_data = this.mydata.get(name);
                    CBEFF tmp_cbeff = new CBEFF(tmp_data);
                    try {
                        Utility.writeStringToFile(tmp_cbeff.toCBEFFString(), CBEFFGen.this._output, name + ".xml");
                        ++this._mycount;
                    }
                    catch (Exception e) {
                        CBEFFGen.this.LOG_OUT.error((Object)"Write of CBEFF failed!", (Throwable)e);
                    }
                    continue;
                }
                CBEFFGen.this.LOG.info((Object)"Batch Complete!");
                this._waiting = true;
                this.fireWorkComplete();
            }
        }

        public int getCount() {
            return this._mycount;
        }

        public boolean alive(boolean truth) {
            return truth;
        }

        public void done() {
            this._waiting = false;
            this._inner_running = false;
        }

        @Override
        public void interrupt(InterruptEvent ie) {
            this.done();
        }
    }
}

