/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFBiometric;
import com.identix.uidai.cbeff.CBEFFFace;
import com.identix.uidai.cbeff.CBEFFFinger;
import com.identix.uidai.cbeff.CBEFFFingerSegment;
import com.identix.uidai.cbeff.CBEFFIris;
import com.identix.uidai.cbeff.FacialISO;
import com.identix.uidai.cbeff.FingerISO;
import com.identix.uidai.cbeff.ImageStruct;
import com.identix.uidai.cbeff.IrisISO;
import com.identix.uidai.cbeff.IrisImageStruct;
import com.identix.uidai.cbeff.UIDAICBEFFDirectoryProcessor;
import com.identix.util.QuickSorter;
import com.identix.util.Timing;
import com.identix.util.Utility;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;
import net.damango.pub.genparser.Branch;
import net.damango.pub.genparser.DocumentHolder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBEFF {
    public static final String ENROLL = new String("enroll");
    public static final String SEARCH = new String("search");
    public static final String VERIFY = new String("verify");
    private Vector<CBEFFFace> _faces = new Vector();
    private Vector<CBEFFFinger> _fingers = new Vector();
    private Vector<CBEFFIris> _irisses = new Vector();
    public static final String _cbeff_version = "2";
    private String _createDate = new String("20101216T162000Z");
    private String _integrity = new String("false");
    private String _purpose = new String(ENROLL);
    private String _filename = new String("");
    private final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    private static final Logger STATIC_LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.CBEFF.class");
    private static final int BUFFER_SIZE = 4096;
    private Timing _get_time = new Timing();
    private Timing _parse_time = new Timing();
    private Timing _gen_time = new Timing();

    public CBEFF() {
        this._get_time = new Timing();
        this._parse_time = new Timing();
        this._gen_time = new Timing();
        this.setCreateDate(new Date());
    }

    public CBEFF(DataInputStream input) throws Exception {
        this(input, 4096);
    }

    public CBEFF(DataInputStream input, int buf_size) throws Exception {
        this._get_time = new Timing();
        this._parse_time = new Timing();
        this._gen_time = new Timing();
        this.parseCBEFFFileGP(Utility.getImageByteArray(input, buf_size, this._get_time), true, true, true);
    }

    public CBEFF(DataInputStream input, boolean face_strict, boolean finger_strict, boolean iris_strict) throws Exception {
        this(input, 4096, true, true, true);
    }

    public CBEFF(DataInputStream input, int buf_size, boolean face_strict, boolean finger_strict, boolean iris_strict) throws Exception {
        this._get_time = new Timing();
        this._parse_time = new Timing();
        this._gen_time = new Timing();
        this.parseCBEFFFileGP(Utility.getImageByteArray(input, buf_size, this._get_time), face_strict, finger_strict, iris_strict);
    }

    public CBEFF(byte[] input) {
        this(null, input);
    }

    public CBEFF(String filename, byte[] input) {
        this(filename, input, true, true, true);
    }

    public CBEFF(byte[] input, boolean face_strict, boolean finger_strict, boolean iris_strict) {
        this(null, input, face_strict, finger_strict, iris_strict);
    }

    public CBEFF(String filename, byte[] input, boolean face_strict, boolean finger_strict, boolean iris_strict) {
        this._get_time = new Timing();
        this._parse_time = new Timing();
        this._gen_time = new Timing();
        if (filename != null && !filename.equals("")) {
            this._filename = new String(filename);
        }
        this.parseCBEFFFileGP(input, face_strict, finger_strict, iris_strict);
    }

    public CBEFF(Vector<String> input) {
        this._get_time = new Timing();
        this._parse_time = new Timing();
        this._gen_time = new Timing();
        this._gen_time.setStart();
        this.setCreateDate(new Date());
        for (int i = 0; i < input.size(); ++i) {
            try {
                CBEFFBiometric tmp_bio;
                String allfilename = input.elementAt(i);
                File tmp_fl = new File(allfilename);
                byte[] tmp_data = Utility.getImageByteArray(tmp_fl, this._get_time);
                String filename = tmp_fl.getName();
                if (filename.contains("_0007_13_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_SLAP, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_14_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_SLAP, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_15_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.THUMBS, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_01_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_THUMB, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_02_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_INDEX, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_03_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_MIDDLE, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_04_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_RING, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_05_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_LITTLE, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_06_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_THUMB, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_07_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_INDEX, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_08_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_MIDDLE, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_09_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_RING, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0007_10_")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_LITTLE, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("_0008_00_")) {
                    tmp_bio = new CBEFFFace(tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFFace.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFace((CBEFFFace)tmp_bio);
                } else if (filename.contains("_0009_01_")) {
                    tmp_bio = new CBEFFIris(CBEFFIris.RIGHT, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFIris.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addIris((CBEFFIris)tmp_bio);
                } else if (filename.contains("_0009_02_")) {
                    tmp_bio = new CBEFFIris(CBEFFIris.LEFT, tmp_data);
                    tmp_bio.setCaptureDate(UIDAICBEFFDirectoryProcessor.getDateFromFilename(filename));
                    tmp_bio.setFileType(CBEFFIris.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addIris((CBEFFIris)tmp_bio);
                } else if (filename.contains("finger.right pointer-finger middle-finger ring-finger little-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_SLAP, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left pointer-finger middle-finger ring-finger little-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_SLAP, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.thumbs")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.THUMBS, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger..")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.THUMBS, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.right thumb")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_THUMB, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.right pointer-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_INDEX, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.right middle-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_MIDDLE, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.right ring-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_RING, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.right little-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.RIGHT_LITTLE, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left thumb")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_THUMB, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left pointer-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_INDEX, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left middle-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_MIDDLE, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left ring-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_RING, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("finger.left little-finger")) {
                    tmp_bio = new CBEFFFinger(CBEFFFinger.LEFT_LITTLE, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFinger.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFinger((CBEFFFinger)tmp_bio);
                } else if (filename.contains("face.null")) {
                    tmp_bio = new CBEFFFace(tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFFace.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addFace((CBEFFFace)tmp_bio);
                } else if (filename.contains("iris.right")) {
                    tmp_bio = new CBEFFIris(CBEFFIris.RIGHT, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFIris.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addIris((CBEFFIris)tmp_bio);
                } else if (filename.contains("iris.left")) {
                    tmp_bio = new CBEFFIris(CBEFFIris.LEFT, tmp_data);
                    tmp_bio.setCaptureDate(new Date());
                    tmp_bio.setFileType(CBEFFIris.decodeFileType(ImageStruct.translateFileExtension(UIDAICBEFFDirectoryProcessor.getExtFromFilename(filename))));
                    this.addIris((CBEFFIris)tmp_bio);
                }
                this._gen_time.setEnd();
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)"Failed to process a biometric file!", (Throwable)e);
            }
        }
    }

    public static boolean checkISOHeaders(byte[] input) {
        boolean output = true;
        try {
            DocumentHolder doc = new DocumentHolder();
            doc.parseXML(input);
            Branch[] main_birs = doc.getBranches("bir");
            if (main_birs != null && main_birs.length < 1) {
                STATIC_LOG.error((Object)"No ISO images returned from the parser!");
                output = false;
            } else {
                for (int i = 0; i < main_birs.length; ++i) {
                    byte[] byte_image;
                    String bio_image;
                    Branch tmp_sb_bir;
                    int j;
                    Branch[] sub_birs;
                    Branch tmp_mn_bir = main_birs[i];
                    Branch bio_info = tmp_mn_bir.getBranch("bdb-info");
                    String type = null;
                    if (bio_info != null) {
                        type = bio_info.getAttribute("type");
                    }
                    if (type != null && type.equalsIgnoreCase("face")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            STATIC_LOG.error((Object)"No faces included in BIR!");
                            output = false;
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            output &= FacialISO.checkHeader(byte_image);
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("iris")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            STATIC_LOG.error((Object)"No Irisses included in BIR!");
                            output = false;
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            output &= IrisISO.checkHeader(byte_image);
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("finger")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            STATIC_LOG.error((Object)"No fingers included in BIR!");
                            output = false;
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            output &= FingerISO.checkHeader(byte_image);
                        }
                        continue;
                    }
                    if (type == null) {
                        STATIC_LOG.error((Object)"Can't parse unspecified biometric type!");
                        output = false;
                        continue;
                    }
                    STATIC_LOG.error((Object)("Unsupported biometric type: " + type));
                    output = false;
                }
            }
            return output;
        }
        catch (Exception e) {
            STATIC_LOG.error((Object)"CBEFF File failed to parse!", (Throwable)e);
            return false;
        }
    }

    private boolean parseCBEFFFileGP(byte[] input) {
        return this.parseCBEFFFileGP(input, true, true, true);
    }

    private boolean parseCBEFFFileGP(byte[] input, boolean face_strict, boolean finger_strict, boolean iris_strict) {
        this._parse_time.setStart();
        try {
            DocumentHolder doc = new DocumentHolder();
            doc.parseXML(input);
            Branch main_info = doc.getBranch("bir-info");
            if (main_info != null) {
                String integrity = main_info.getAttribute("integrity");
                String creator = main_info.getAttribute("creation-date");
                this.setIntegrity(integrity);
                this.setCreationDate(creator);
            } else {
                this.LOG.info((Object)"No main info!");
            }
            Branch[] main_birs = doc.getBranches("bir");
            if (main_birs != null && main_birs.length < 1) {
                this.LOG.info((Object)"No BIRs returned from the parser!");
            } else {
                for (int i = 0; i < main_birs.length; ++i) {
                    byte[] byte_image;
                    String bio_image;
                    String man_seg;
                    String qual_alg_type;
                    String qual_alg_own;
                    String qual;
                    String subtype;
                    String creationdate;
                    Branch sub_bio_info;
                    String tmp_attempt;
                    Branch sub_bir_info;
                    Branch tmp_sb_bir;
                    int j;
                    Branch[] sub_birs;
                    Branch tmp_mn_bir = main_birs[i];
                    Branch bio_info = tmp_mn_bir.getBranch("bdb-info");
                    String type = null;
                    if (bio_info != null) {
                        type = bio_info.getAttribute("type");
                    } else {
                        this.LOG.info((Object)"No biometric info!");
                    }
                    if (type != null && type.equalsIgnoreCase("face")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No faces included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No facial sub-biometric info!");
                            }
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            Vector<ImageStruct> faces = FacialISO.getImagesFromPackage(byte_image, face_strict);
                            for (ImageStruct face : faces) {
                                CBEFFFace new_face = new CBEFFFace();
                                new_face.setAttempt(tmp_attempt);
                                new_face.setQuality(qual);
                                new_face.setQualityAlgOwner(qual_alg_own);
                                new_face.setQualityAlgType(qual_alg_type);
                                new_face.setManualSegmentation(man_seg);
                                new_face.setImage(face.getImage());
                                new_face.setType(CBEFFBiometric.FACE);
                                new_face.setCaptureDate(creationdate);
                                new_face.setFileType(CBEFFFace.decodeFileType(face.getImageType()));
                                this.addFace(new_face);
                            }
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("iris")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No Irisses included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No iris sub-biometric info!");
                            }
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            Vector<IrisImageStruct> irisses = IrisISO.getImagesFromPackage(byte_image, iris_strict);
                            for (IrisImageStruct iris : irisses) {
                                CBEFFIris new_iris = new CBEFFIris();
                                new_iris.setAttempt(tmp_attempt);
                                new_iris.setQuality(qual);
                                new_iris.setQualityAlgOwner(qual_alg_own);
                                new_iris.setQualityAlgType(qual_alg_type);
                                new_iris.setManualSegmentation(man_seg);
                                new_iris.setImage(iris.getImage());
                                new_iris.setType(CBEFFBiometric.IRIS);
                                new_iris.setSubType(CBEFFIris.decodePosition(iris.getPosition()));
                                new_iris.setCaptureDate(creationdate);
                                new_iris.setFileType(CBEFFIris.decodeFileType(iris.getImageType()));
                                new_iris.setHorizontalOrientation(iris.getHorizontalOrientation());
                                new_iris.setVerticalOrientation(iris.getVerticalOrientation());
                                new_iris.setScanType(iris.getScanType());
                                new_iris.setOcclusions(iris.getOcclusions());
                                new_iris.setOcclusionFilling(iris.getOcclusionFilling());
                                new_iris.setBoundaryExtraction(iris.getBoundaryExtraction());
                                this.addIris(new_iris);
                            }
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("finger")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No fingers included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No finger sub-biometric info!");
                            }
                            Vector<CBEFFFingerSegment> tmp_segs = new Vector<CBEFFFingerSegment>();
                            Branch[] segs = sub_bio_info.getBranches("segment");
                            if (segs.length < 1) {
                                this.LOG.info((Object)"No segments included with finger image.");
                            } else {
                                for (int k = 0; k < segs.length; ++k) {
                                    CBEFFFingerSegment tmp_seg = new CBEFFFingerSegment();
                                    tmp_seg.setFingerPosition(segs[k].getInfo("position"));
                                    tmp_seg.setSegConfidence(segs[k].getInfo("seg-confidence"));
                                    tmp_seg.setQuality(segs[k].getInfo("quality"));
                                    tmp_seg.setQualityAlgOwner(segs[k].getInfo("quality-alg-owner"));
                                    tmp_seg.setQualityAlgType(segs[k].getInfo("quality-alg-type"));
                                    Branch tmp_box = segs[k].getBranch("box");
                                    if (tmp_box != null) {
                                        tmp_seg.setXCentre(tmp_box.getInfo("xCentre"));
                                        tmp_seg.setYCentre(tmp_box.getInfo("yCentre"));
                                        tmp_seg.setWidth(tmp_box.getInfo("width"));
                                        tmp_seg.setHeight(tmp_box.getInfo("height"));
                                        tmp_seg.setAngle(tmp_box.getInfo("angle"));
                                        tmp_seg.setOrientation(tmp_box.getInfo("orientation"));
                                    }
                                    tmp_segs.add(tmp_seg);
                                }
                            }
                            String bio_image2 = tmp_sb_bir.getInfo("bdb");
                            byte[] byte_image2 = Utility.convertFromBase64(bio_image2);
                            Vector<ImageStruct> fingers = FingerISO.getImagesFromPackage(byte_image2, finger_strict);
                            for (ImageStruct finger : fingers) {
                                CBEFFFinger new_finger = new CBEFFFinger();
                                new_finger.setAttempt(tmp_attempt);
                                new_finger.setQuality(qual);
                                new_finger.setQualityAlgOwner(qual_alg_own);
                                new_finger.setQualityAlgType(qual_alg_type);
                                new_finger.setManualSegmentation(man_seg);
                                new_finger.addSegments(tmp_segs);
                                new_finger.setImage(finger.getImage());
                                new_finger.setType(CBEFFBiometric.FINGER);
                                new_finger.setSubType(CBEFFFinger.decodePosition(finger.getPosition()));
                                new_finger.setSlapSubtype(subtype);
                                new_finger.setCaptureDate(creationdate);
                                new_finger.setFileType(CBEFFFinger.decodeFileType(finger.getImageType()));
                                this.addFinger(new_finger);
                            }
                        }
                        continue;
                    }
                    if (type == null) {
                        this.LOG.error((Object)"Can't parse unspecified biometric type");
                        continue;
                    }
                    this.LOG.error((Object)("Unsupported biometric type: " + type));
                }
            }
            this._parse_time.setEnd();
            return true;
        }
        catch (Exception e) {
            this.LOG.error((Object)"CBEFF File failed to parse!", (Throwable)e);
            this._parse_time.setEnd();
            return false;
        }
    }

    public Vector<CBEFFFace> getFaces() {
        return this._faces;
    }

    public Vector<CBEFFFinger> getFingers() {
        return this._fingers;
    }

    public Vector<CBEFFIris> getIrisses() {
        return this._irisses;
    }

    public String getIntegrity() {
        return this._integrity;
    }

    public Date getCreateDate() {
        return Utility.parseDate(this._createDate);
    }

    public String getPurpose() {
        return this._purpose;
    }

    public long getGetTime() {
        return this._get_time.getDuration();
    }

    public Timing getGetTiming() {
        return this._get_time;
    }

    public long getParseTime() {
        return this._parse_time.getDuration();
    }

    public Timing getParseTiming() {
        return this._parse_time;
    }

    public long getGenTime() {
        return this._gen_time.getDuration();
    }

    public Timing getGenTiming() {
        return this._gen_time;
    }

    public void addFace(CBEFFFace input) {
        this._faces.addElement(input);
    }

    public void addFinger(CBEFFFinger input) {
        this._fingers.addElement(input);
    }

    public void addIris(CBEFFIris input) {
        this._irisses.addElement(input);
    }

    public void setIntegrity(String input) {
        this._integrity = new String(input);
    }

    public void setCreationDate(String input) {
        this._createDate = new String(input);
    }

    public void setCreateDate(Date input) {
        if (input != null) {
            this._createDate = new String(Utility.formatDate(input));
        }
    }

    public void setPurpose(String input) {
        if (input != null) {
            this._purpose = new String(input);
        }
    }

    public String toStringGP() {
        QuickSorter<CBEFFBiometric> _sorter;
        Branch bdb_info;
        Branch bir_info;
        Branch bir;
        CBEFFBiometric tmp_data_1;
        StringBuffer output = new StringBuffer();
        output.append("<?xml version='1.0' encoding=\"utf-8\"?>\n");
        DocumentHolder root = new DocumentHolder("bir");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttribute("xmlns", "http://uidai.gov.in");
        root.setAttribute("xsi:schemaLocation", "http://uidai.gov.in/CBEFF_uidai.xsd");
        root.setInfo("patron-format-owner", "XXXX");
        root.setInfo("patron-format-type", "0001");
        Branch main_ver = new Branch();
        main_ver.setAttribute("major", "1");
        main_ver.setAttribute("minor", "0");
        root.addBranch("version", main_ver);
        Branch main_cbeff_ver = new Branch();
        main_cbeff_ver.setAttribute("major", _cbeff_version);
        main_cbeff_ver.setAttribute("minor", "0");
        root.addBranch("cbeff-version", main_cbeff_ver);
        Branch main_info = new Branch();
        main_info.setAttribute("integrity", "false");
        main_info.setAttribute("creation-date", this._createDate);
        root.addBranch("bir-info", main_info);
        if (this._faces != null && this._faces.size() > 0) {
            tmp_data_1 = this._faces.elementAt(0);
            bir = new Branch();
            bir_info = new Branch();
            bir_info.setAttribute("integrity", "false");
            bir_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bir.addBranch("bir-info", bir_info);
            bdb_info = new Branch();
            bdb_info.setAttribute("format-owner", "257");
            bdb_info.setAttribute("format-type", "8");
            bdb_info.setAttribute("encryption", "false");
            bdb_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bdb_info.setAttribute("type", tmp_data_1.getType());
            bir.addBranch("bdb-info", bdb_info);
            _sorter = new QuickSorter<CBEFFFace>(this._faces);
            Vector<CBEFFFace> _sorted_faces = _sorter.sort();
            for (CBEFFFace cBEFFFace : _sorted_faces) {
                bir.addBranch(cBEFFFace.getBranchName(), cBEFFFace.getGPBranch());
            }
            root.addBranch("bir", bir);
        }
        if (this._irisses != null && this._irisses.size() > 0) {
            tmp_data_1 = this._irisses.elementAt(0);
            bir = new Branch();
            bir_info = new Branch();
            bir_info.setAttribute("integrity", "false");
            bir_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bir.addBranch("bir-info", bir_info);
            bdb_info = new Branch();
            bdb_info.setAttribute("format-owner", "257");
            bdb_info.setAttribute("format-type", "9");
            bdb_info.setAttribute("encryption", "false");
            bdb_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bdb_info.setAttribute("type", tmp_data_1.getType());
            bir.addBranch("bdb-info", bdb_info);
            _sorter = new QuickSorter<CBEFFIris>(this._irisses);
            Vector<CBEFFBiometric> _sorted_irisses = _sorter.sort();
            for (CBEFFIris cBEFFIris : _sorted_irisses) {
                bir.addBranch(cBEFFIris.getBranchName(), cBEFFIris.getGPBranch());
            }
            root.addBranch("bir", bir);
        }
        if (this._fingers != null && this._fingers.size() > 0) {
            tmp_data_1 = this._fingers.elementAt(0);
            bir = new Branch();
            bir_info = new Branch();
            bir_info.setAttribute("integrity", "false");
            bir_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bir.addBranch("bir-info", bir_info);
            bdb_info = new Branch();
            bdb_info.setAttribute("format-owner", "257");
            bdb_info.setAttribute("format-type", "7");
            bdb_info.setAttribute("encryption", "false");
            bdb_info.setAttribute("creation-date", tmp_data_1.getCaptureDate());
            bdb_info.setAttribute("type", tmp_data_1.getType());
            bir.addBranch("bdb-info", bdb_info);
            _sorter = new QuickSorter<CBEFFFinger>(this._fingers);
            Vector<CBEFFBiometric> _sorted_fingers = _sorter.sort();
            for (CBEFFFinger cBEFFFinger : _sorted_fingers) {
                bir.addBranch(cBEFFFinger.getBranchName(), cBEFFFinger.getGPBranch());
            }
            root.addBranch("bir", bir);
        }
        return output.append(root.toString()).toString();
    }

    public String toCBEFFString() {
        QuickSorter<CBEFFBiometric> _sorter;
        CBEFFBiometric tmp_data_1;
        StringBuffer output = new StringBuffer();
        output.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        output.append("<bir xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://uidai.gov.in\" xsi:schemaLocation=\"http://uidai.gov.in/CBEFF_uidai.xsd\">\n");
        output.append("\t<patron-format-owner>XXXX</patron-format-owner>\n");
        output.append("\t<patron-format-type>0001</patron-format-type>\n");
        output.append("\t<version major=\"1\" minor=\"0\" />\n");
        output.append("\t<cbeff-version major=\"2\" minor=\"0\" />\n");
        output.append("\t<bir-info integrity=\"false\" creation-date=\"" + this._createDate + "\" />\n");
        if (this._faces != null && this._faces.size() > 0) {
            tmp_data_1 = this._faces.elementAt(0);
            output.append("\t<bir>\n");
            output.append("\t\t<bir-info integrity=\"false\" creation-date=\"" + tmp_data_1.getCaptureDate() + "\" />\n");
            output.append("\t\t<bdb-info format-owner=\"257\" format-type=\"8\" encryption=\"false\" ");
            output.append("creation-date=\"" + tmp_data_1.getCaptureDate() + "\" type=\"" + tmp_data_1.getType() + "\" />\n");
            _sorter = new QuickSorter<CBEFFFace>(this._faces);
            Vector<CBEFFFace> _sorted_faces = _sorter.sort();
            this.LOG.info((Object)("Faces: " + this._faces + "\nSorted Face: " + _sorted_faces));
            for (CBEFFFace cBEFFFace : _sorted_faces) {
                output.append(cBEFFFace.toCBEFFString("\t\t"));
            }
            output.append("\t</bir>\n");
        }
        if (this._irisses != null && this._irisses.size() > 0) {
            tmp_data_1 = this._irisses.elementAt(0);
            output.append("\t<bir>\n");
            output.append("\t\t<bir-info integrity=\"false\" creation-date=\"" + tmp_data_1.getCaptureDate() + "\"/>\n");
            output.append("\t\t<bdb-info format-owner=\"257\" format-type=\"9\" encryption=\"false\" ");
            output.append("creation-date=\"" + tmp_data_1.getCaptureDate() + "\" type=\"" + tmp_data_1.getType() + "\" />\n");
            _sorter = new QuickSorter<CBEFFIris>(this._irisses);
            Vector<CBEFFBiometric> _sorted_irisses = _sorter.sort();
            this.LOG.info((Object)("Irisses: " + this._irisses + "\nSorted Iris: " + _sorted_irisses));
            for (CBEFFIris cBEFFIris : _sorted_irisses) {
                output.append(cBEFFIris.toCBEFFString("\t\t"));
            }
            output.append("\t</bir>\n");
        }
        if (this._fingers != null && this._fingers.size() > 0) {
            tmp_data_1 = this._fingers.elementAt(0);
            output.append("\t<bir>\n");
            output.append("\t\t<bir-info integrity=\"false\" creation-date=\"" + tmp_data_1.getCaptureDate() + "\"/>\n");
            output.append("\t\t<bdb-info format-owner=\"257\" format-type=\"7\" encryption=\"false\" ");
            output.append("creation-date=\"" + tmp_data_1.getCaptureDate() + "\" type=\"" + tmp_data_1.getType() + "\" />\n");
            _sorter = new QuickSorter<CBEFFFinger>(this._fingers);
            Vector<CBEFFBiometric> _sorted_fingers = _sorter.sort();
            this.LOG.info((Object)("Fingers: " + this._fingers + "\nSorted Finger: " + _sorted_fingers));
            for (CBEFFFinger cBEFFFinger : _sorted_fingers) {
                output.append(cBEFFFinger.toCBEFFString("\t\t"));
            }
            output.append("\t</bir>\n");
        }
        output.append("</bir>\n");
        return output.toString();
    }

    public static void main(String[] args) {
        Logger MAIN_LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.CBEFF.class");
        if (args.length < 1) {
            MAIN_LOG.error((Object)"Invalid Arguments: Must specify a CBEFF file to parse or -l to read list of files from STDIN!");
            System.exit(-1);
        } else if (args[0].equalsIgnoreCase("-l")) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String fname = null;
                File input = null;
                fname = stdin.readLine();
                while (fname != null) {
                    byte[] cbeff_file_data = null;
                    try {
                        MAIN_LOG.info((Object)("Attempting to read file \"" + fname + "\" at " + new Date().getTime()));
                        input = new File(fname);
                        MAIN_LOG.info((Object)("'Real' file name \"" + input.getAbsolutePath() + "\""));
                        cbeff_file_data = Utility.getImageByteArray(input);
                        MAIN_LOG.info((Object)("Length of data: " + cbeff_file_data.length));
                        MAIN_LOG.info((Object)("File read by " + new Date().getTime()));
                    }
                    catch (Exception e) {
                        MAIN_LOG.error((Object)"Reading CBEFF file failed!", (Throwable)e);
                        System.exit(-2);
                    }
                    String out_folder = new String("output" + File.separator + input.getName().replace(".xml", ""));
                    try {
                        new File(out_folder).mkdirs();
                        MAIN_LOG.info((Object)("Attempting to parse read data at " + new Date().getTime()));
                        CBEFF my_cbeff = new CBEFF(cbeff_file_data, true, false, false);
                        MAIN_LOG.info((Object)("Completed parsing read data at " + new Date().getTime()));
                        Vector<CBEFFFace> faces = my_cbeff.getFaces();
                        for (int i = 0; i < faces.size(); ++i) {
                            CBEFFFace tmp_image = faces.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                MAIN_LOG.error((Object)"Writing parsed facial image failed!", (Throwable)e);
                                System.exit(-3);
                            }
                        }
                        Vector<CBEFFIris> irisses = my_cbeff.getIrisses();
                        for (int i = 0; i < irisses.size(); ++i) {
                            CBEFFIris tmp_image = irisses.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                MAIN_LOG.error((Object)"Writing parsed finger image failed!", (Throwable)e);
                                System.exit(-3);
                            }
                        }
                        Vector<CBEFFFinger> fingers = my_cbeff.getFingers();
                        for (int i = 0; i < fingers.size(); ++i) {
                            CBEFFFinger tmp_image = fingers.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            String slap_sub = tmp_image.getSlapSubType();
                            Vector<Integer> missing = tmp_image.getMissingFingers();
                            Vector<CBEFFFingerSegment> segments = tmp_image.getSegments();
                            MAIN_LOG.info((Object)("Finger SUBTYPE=\"" + subtype + "\" SLAP_TYPE=\"" + slap_sub + "\" MISSING=\"" + missing.toString() + "\" SEGMENTS=\"" + segments.toString()));
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + slap_sub + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                MAIN_LOG.error((Object)"Writing parsed finger image failed!", (Throwable)e);
                                System.exit(-3);
                            }
                        }
                    }
                    catch (Exception e) {
                        MAIN_LOG.error((Object)"Extracting images failed!", (Throwable)e);
                        System.exit(-4);
                    }
                    fname = stdin.readLine();
                }
            }
            catch (Exception e) {
                MAIN_LOG.error((Object)"Extracting images failed!", (Throwable)e);
                System.exit(-4);
            }
        } else {
            byte[] cbeff_file_data = null;
            File input = null;
            try {
                input = new File(args[0]);
                cbeff_file_data = Utility.getImageByteArray(input);
                MAIN_LOG.info((Object)("Length of data: " + cbeff_file_data.length));
            }
            catch (Exception e) {
                MAIN_LOG.error((Object)"Reading CBEFF file failed!", (Throwable)e);
                System.exit(-2);
            }
            String out_folder = new String("output" + File.separator + input.getName().replace(".xml", ""));
            try {
                new File(out_folder).mkdirs();
                CBEFF my_cbeff = new CBEFF(cbeff_file_data, true, false, false);
                Vector<CBEFFFace> faces = my_cbeff.getFaces();
                for (int i = 0; i < faces.size(); ++i) {
                    CBEFFFace tmp_image = faces.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        MAIN_LOG.error((Object)"Writing parsed facial image failed!", (Throwable)e);
                        System.exit(-3);
                    }
                }
                Vector<CBEFFIris> irisses = my_cbeff.getIrisses();
                for (int i = 0; i < irisses.size(); ++i) {
                    CBEFFIris tmp_image = irisses.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        MAIN_LOG.error((Object)"Writing parsed finger image failed!", (Throwable)e);
                        System.exit(-3);
                    }
                }
                Vector<CBEFFFinger> fingers = my_cbeff.getFingers();
                for (int i = 0; i < fingers.size(); ++i) {
                    CBEFFFinger tmp_image = fingers.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    String slap_sub = tmp_image.getSlapSubType();
                    Vector<Integer> missing = tmp_image.getMissingFingers();
                    Vector<CBEFFFingerSegment> segments = tmp_image.getSegments();
                    MAIN_LOG.info((Object)("Finger SUBTYPE=\"" + subtype + "\" SLAP_TYPE=\"" + slap_sub + "\" MISSING=\"" + missing.toString() + "\" SEGMENTS=\"" + segments.toString()));
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + slap_sub + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        MAIN_LOG.error((Object)"Writing parsed finger image failed!", (Throwable)e);
                        System.exit(-3);
                    }
                }
            }
            catch (Exception e) {
                MAIN_LOG.error((Object)"Extracting images failed!", (Throwable)e);
                System.exit(-4);
            }
        }
    }
}

