/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.util.Utility;
import java.util.Date;

public abstract class CBEFFBiometric
implements Comparable {
    public static final String FACE = new String("face");
    public static final String IRIS = new String("iris");
    public static final String FINGER = new String("finger");
    protected byte[] _image = null;
    protected String _type = null;
    protected String _subtype = null;
    protected String _captureDate = null;
    protected int _fileType = 0;
    protected int _attempt = 1;
    protected String _quality = "";
    protected String _quality_alg_own = "";
    protected String _quality_alg_type = "";
    protected boolean _manual_segmentation = false;

    public CBEFFBiometric() {
    }

    public CBEFFBiometric(String type, String subtype, byte[] image) {
        this.setType(type);
        this.setSubType(subtype);
        this.setImage(image);
    }

    public byte[] getImage() {
        return this._image;
    }

    public byte[] getImageBase64() {
        return Utility.convertToBase64(this._image);
    }

    public byte[] getImageISOBase64() {
        return Utility.convertToBase64(this.packageImage(this._image));
    }

    public String getType() {
        return this._type;
    }

    public String getSubType() {
        return this._subtype;
    }

    public String getCaptureDate() {
        return this._captureDate;
    }

    public int getFileType() {
        return this._fileType;
    }

    public int getAttempt() {
        return this._attempt;
    }

    public String getQuality() {
        return this._quality;
    }

    public String getQualityAlgOwner() {
        return this._quality_alg_own;
    }

    public String getQualityAlgType() {
        return this._quality_alg_type;
    }

    public boolean getManualSegmentation() {
        return this._manual_segmentation;
    }

    public void setImage(byte[] input) {
        if (input != null) {
            this._image = (byte[])input.clone();
        }
    }

    public abstract byte[] packageImage(byte[] var1);

    public void setType(String input) {
        if (input != null) {
            this._type = new String(input);
        }
    }

    public void setSubType(String input) {
        if (input != null) {
            this._subtype = new String(input);
        }
    }

    public void setCaptureDate(Date input) {
        if (input != null) {
            this._captureDate = new String(Utility.formatDate(input));
        }
    }

    public void setCaptureDate(String input) {
        if (input != null) {
            this._captureDate = new String(input);
        }
    }

    public void setFileType(int input) {
        this._fileType = input;
    }

    public void setAttempt(int input) {
        this._attempt = input > 0 ? input : 1;
    }

    public void setAttempt(String input) {
        if (input != null && !input.equals("")) {
            try {
                this._attempt = new Integer(input);
            }
            catch (Exception e) {
                this._attempt = 1;
            }
        } else {
            this._attempt = 1;
        }
    }

    public void setQuality(String input) {
        this._quality = input != null && !input.equals("") ? new String(input) : "";
    }

    public void setQualityAlgOwner(String input) {
        this._quality_alg_own = input != null && !input.equals("") ? new String(input) : "";
    }

    public void setQualityAlgType(String input) {
        this._quality_alg_type = input != null && !input.equals("") ? new String(input) : "";
    }

    public void setManualSegmentation(String input) {
        if (input != null && !input.equals("")) {
            try {
                this._manual_segmentation = new Boolean(input);
            }
            catch (Exception e) {
                this._manual_segmentation = false;
            }
        }
    }

    public void setManualSegmentation(boolean input) {
        this._manual_segmentation = input;
    }

    public abstract String translateImageType(int var1);

    public int compareTo(Object input) {
        if (input instanceof CBEFFBiometric) {
            String tmp_type = ((CBEFFBiometric)input).getType();
            if (this._type.equals(tmp_type)) {
                return 0;
            }
            if (this._type.equals(FACE)) {
                return -1;
            }
            if (this._type.equals(IRIS)) {
                if (tmp_type.equals(FACE)) {
                    return 1;
                }
                return -1;
            }
            if (this._type.equals(FINGER)) {
                return 1;
            }
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "(Type: " + this._type + " SubType: " + this._subtype + " Date: " + this._captureDate + " FileType: " + this.translateImageType(this._fileType) + ")";
    }
}

