/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFBiometric;
import com.identix.uidai.cbeff.FacialISO;
import net.damango.pub.genparser.Branch;
import org.apache.log4j.Logger;

public class CBEFFFace
extends CBEFFBiometric
implements Comparable {
    public static final int JPEG = 0;
    public static final int JPEG_2000 = 1;
    public static final int DEFAULT = 2;
    protected final Logger LOG = Logger.getLogger((String)this.getClass().getName());

    public CBEFFFace() {
        this.setType(FACE);
    }

    public CBEFFFace(byte[] image) {
        this.setType(FACE);
        this.setImage(image);
    }

    public byte[] packageImage(byte[] input) {
        this.LOG.info((Object)("Packaging Face with file type: " + this.getFileType()));
        byte[] output = FacialISO.packageImage(input, this.getFileType(), 0, 0);
        return output;
    }

    public static int decodeFileType(int input) {
        switch (input) {
            case 2: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    public static int encodeFileType(int input) {
        switch (input) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return 8;
    }

    public String translateImageType(int input) {
        switch (input) {
            case 0: {
                return "jpg";
            }
            case 1: {
                return "jp2";
            }
        }
        return "raw";
    }

    public int compareTo(Object input) {
        int supcomp = super.compareTo(input);
        if (supcomp != 0) {
            return supcomp;
        }
        String tmp_cap = ((CBEFFFace)input).getCaptureDate();
        return this._captureDate.compareTo(tmp_cap);
    }

    public String getBranchName() {
        return "bir";
    }

    public Branch getGPBranch() {
        Branch img_bir = new Branch();
        Branch img_bir_info = new Branch();
        img_bir_info.setAttribute("integrity", "false");
        img_bir_info.setAttribute("creation-date", this.getCaptureDate());
        img_bir_info.setAttribute("attempt", "" + this.getAttempt());
        img_bir.addBranch("bir-info", img_bir_info);
        Branch img_bdb_info = new Branch();
        img_bdb_info.setAttribute("format-owner", "257");
        img_bdb_info.setAttribute("format-type", "8");
        img_bdb_info.setAttribute("encryption", "false");
        img_bdb_info.setAttribute("creation-date", this.getCaptureDate());
        img_bdb_info.setAttribute("quality", this.getQuality());
        img_bdb_info.setAttribute("quality-alg-owner", this.getQualityAlgOwner());
        img_bdb_info.setAttribute("quality-alg-type", this.getQualityAlgType());
        img_bdb_info.setAttribute("manual-segmentation", "" + this.getManualSegmentation());
        img_bir.addBranch("bdb-info", img_bdb_info);
        img_bir.setInfo("bdb", new String(this.getImageISOBase64()));
        return img_bir;
    }

    public String toCBEFFString() {
        return this.toCBEFFString("");
    }

    public String toCBEFFString(String line_pre) {
        String output = new String("");
        output = output + line_pre + "<bir>\n";
        output = output + line_pre + "\t<bir-info integrity=\"false\" creation-date=\"" + this.getCaptureDate() + "\" ";
        output = output + "attempt=\"" + this.getAttempt() + "\" />\n";
        output = output + line_pre + "\t<bdb-info format-owner=\"257\" format-type=\"8\" encryption=\"false\" ";
        output = output + "creation-date=\"" + this.getCaptureDate() + "\" quality=\"" + this.getQuality() + "\" quality-alg-owner=\"";
        output = output + this.getQualityAlgOwner() + "\" quality-alg-type=\"" + this.getQualityAlgType();
        output = output + "\" manual-segmentation=\"" + this.getManualSegmentation() + "\" />\n";
        output = output + line_pre + "\t<bdb>" + new String(this.getImageISOBase64()) + "</bdb>\n";
        output = output + line_pre + "</bir>\n";
        return output;
    }
}

