/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFBiometric;
import com.identix.uidai.cbeff.CBEFFFingerSegment;
import com.identix.uidai.cbeff.FingerISO;
import java.util.StringTokenizer;
import java.util.Vector;
import net.damango.pub.genparser.Branch;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBEFFFinger
extends CBEFFBiometric
implements Comparable {
    public static final String LEFT_SLAP = new String("left pointer-finger middle-finger ring-finger little-finger");
    public static final String RIGHT_SLAP = new String("right pointer-finger middle-finger ring-finger little-finger");
    public static final String THUMBS = new String("left right thumb");
    public static final String LEFT_LITTLE = new String("left little-finger");
    public static final String LEFT_RING = new String("left ring-finger");
    public static final String LEFT_MIDDLE = new String("left middle-finger");
    public static final String LEFT_INDEX = new String("left pointer-finger");
    public static final String LEFT_THUMB = new String("left thumb");
    public static final String RIGHT_LITTLE = new String("right little-finger");
    public static final String RIGHT_RING = new String("right ring-finger");
    public static final String RIGHT_MIDDLE = new String("right middle-finger");
    public static final String RIGHT_INDEX = new String("right pointer-finger");
    public static final String RIGHT_THUMB = new String("right thumb");
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final String LEFT_STR = new String("left");
    public static final String RIGHT_STR = new String("right");
    public static final String LITTLE = new String("little-finger");
    public static final String RING = new String("ring-finger");
    public static final String MIDDLE = new String("middle-finger");
    public static final String INDEX = new String("pointer-finger");
    public static final String THUMB = new String("thumb");
    public static final int RAW = 0;
    public static final int RAW_BIT_PACK = 1;
    public static final int WSQ = 2;
    public static final int JPEG = 3;
    public static final int JPEG_2000 = 4;
    public static final int PNG = 5;
    protected final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    protected Vector<String> _subtypes = new Vector();
    protected Vector<CBEFFFingerSegment> _segments = new Vector();
    protected String _slap_subtype = null;
    protected Vector<Integer> _missingFingers = new Vector();

    public CBEFFFinger() {
        this.setType(FINGER);
        this._segments = new Vector();
        this.buildComparator();
    }

    public CBEFFFinger(String subtype, byte[] image) {
        this.setType(FINGER);
        this.setSubType(subtype);
        this.setImage(image);
        this._segments = new Vector();
        this.buildComparator();
    }

    public CBEFFFinger(String subtype, byte[] image, Vector<CBEFFFingerSegment> segments) {
        this.setType(FINGER);
        this.setSubType(subtype);
        this.setImage(image);
        this._segments = (Vector)segments.clone();
        this.buildComparator();
    }

    public String getSlapSubType() {
        return this._slap_subtype;
    }

    public void addSegment(CBEFFFingerSegment input) {
        if (input != null) {
            if (this._segments == null) {
                this._segments = new Vector();
            }
            this._segments.add(input);
        }
    }

    public void addSegments(Vector<CBEFFFingerSegment> input) {
        if (input != null && input.size() > 0) {
            if (this._segments == null || this._segments.size() < 1) {
                this._segments = (Vector)input.clone();
            } else {
                for (CBEFFFingerSegment tmp_seg : input) {
                    this._segments.add(tmp_seg);
                }
            }
        }
    }

    public Vector<CBEFFFingerSegment> getSegments() {
        if (this._segments == null) {
            this._segments = new Vector();
        }
        return this._segments;
    }

    public void setSlapSubtype(String input) {
        if (input != null && !input.equals("")) {
            this._slap_subtype = new String(input);
            this.buildMissingFingers();
        }
    }

    public Vector<Integer> getMissingFingers() {
        if (this._missingFingers == null) {
            this._missingFingers = new Vector();
        }
        return this._missingFingers;
    }

    public void buildMissingFingers() {
        block4: {
            block7: {
                block6: {
                    block5: {
                        if (this._slap_subtype == null || this._slap_subtype.equals("")) break block4;
                        this._missingFingers = new Vector();
                        if (!this._slap_subtype.trim().equals(LEFT_THUMB)) break block5;
                        this._missingFingers.add(new Integer(CBEFFFinger.decodePosition(RIGHT_THUMB)));
                        break block4;
                    }
                    if (!this._slap_subtype.trim().equals(RIGHT_THUMB)) break block6;
                    this._missingFingers.add(new Integer(CBEFFFinger.decodePosition(LEFT_THUMB)));
                    break block4;
                }
                if (this._slap_subtype.trim().equals(THUMBS)) break block4;
                if (!this._slap_subtype.startsWith(LEFT_STR)) break block7;
                Vector<String> total_fing = this.buildFingerVector();
                StringTokenizer tok = new StringTokenizer(this._slap_subtype.replace(LEFT_STR + " ", ""), " ");
                while (tok.hasMoreTokens()) {
                    total_fing.remove(tok.nextToken());
                }
                for (int i = 0; i < total_fing.size(); ++i) {
                    this._missingFingers.add(new Integer(CBEFFFinger.decodePosition(total_fing.elementAt(i), 2)));
                }
                break block4;
            }
            if (!this._slap_subtype.startsWith(RIGHT_STR)) break block4;
            Vector<String> total_fing = this.buildFingerVector();
            StringTokenizer tok = new StringTokenizer(this._slap_subtype.replace(RIGHT_STR + " ", ""), " ");
            while (tok.hasMoreTokens()) {
                total_fing.remove(tok.nextToken());
            }
            for (int i = 0; i < total_fing.size(); ++i) {
                this._missingFingers.add(new Integer(CBEFFFinger.decodePosition(total_fing.elementAt(i), 1)));
            }
        }
    }

    public Vector<String> buildFingerVector() {
        Vector<String> output = new Vector<String>();
        output.add(LITTLE);
        output.add(RING);
        output.add(MIDDLE);
        output.add(INDEX);
        return output;
    }

    public void buildComparator() {
        this._subtypes = new Vector();
        this._subtypes.add(LEFT_SLAP);
        this._subtypes.add(RIGHT_SLAP);
        this._subtypes.add(THUMBS);
        this._subtypes.add(RIGHT_THUMB);
        this._subtypes.add(RIGHT_INDEX);
        this._subtypes.add(RIGHT_MIDDLE);
        this._subtypes.add(RIGHT_RING);
        this._subtypes.add(RIGHT_LITTLE);
        this._subtypes.add(LEFT_THUMB);
        this._subtypes.add(LEFT_INDEX);
        this._subtypes.add(LEFT_MIDDLE);
        this._subtypes.add(LEFT_RING);
        this._subtypes.add(LEFT_LITTLE);
    }

    @Override
    public byte[] packageImage(byte[] input) {
        this.LOG.info((Object)("Packaging Finger with file type: " + this.getFileType() + " SubType: " + this.getSubType()));
        byte[] output = FingerISO.packageImage(input, this.getFileType(), CBEFFFinger.decodePosition(this.getSubType()), 0, 0);
        return output;
    }

    public static int decodeFileType(int input) {
        switch (input) {
            case 2: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 0;
            }
            case 10: {
                return 1;
            }
        }
        return 4;
    }

    public static int encodeFileType(int input) {
        switch (input) {
            case 3: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 0: {
                return 8;
            }
            case 1: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public String translateImageType(int input) {
        switch (input) {
            case 3: {
                return "jpg";
            }
            case 2: {
                return "wsq";
            }
            case 5: {
                return "png";
            }
            case 0: {
                return "raw";
            }
            case 1: {
                return "bpi";
            }
        }
        return "jp2";
    }

    public static String decodePosition(int input) {
        switch (input) {
            case 1: {
                return RIGHT_THUMB;
            }
            case 2: {
                return RIGHT_INDEX;
            }
            case 3: {
                return RIGHT_MIDDLE;
            }
            case 4: {
                return RIGHT_RING;
            }
            case 5: {
                return RIGHT_LITTLE;
            }
            case 6: {
                return LEFT_THUMB;
            }
            case 7: {
                return LEFT_INDEX;
            }
            case 8: {
                return LEFT_MIDDLE;
            }
            case 9: {
                return LEFT_RING;
            }
            case 10: {
                return LEFT_LITTLE;
            }
            case 13: {
                return RIGHT_SLAP;
            }
            case 14: {
                return LEFT_SLAP;
            }
            case 15: {
                return THUMBS;
            }
        }
        return "";
    }

    public static int decodePosition(String input) {
        if (input.equals(RIGHT_THUMB)) {
            return 1;
        }
        if (input.equals(RIGHT_INDEX)) {
            return 2;
        }
        if (input.equals(RIGHT_MIDDLE)) {
            return 3;
        }
        if (input.equals(RIGHT_RING)) {
            return 4;
        }
        if (input.equals(RIGHT_LITTLE)) {
            return 5;
        }
        if (input.equals(LEFT_THUMB)) {
            return 6;
        }
        if (input.equals(LEFT_INDEX)) {
            return 7;
        }
        if (input.equals(LEFT_MIDDLE)) {
            return 8;
        }
        if (input.equals(LEFT_RING)) {
            return 9;
        }
        if (input.equals(LEFT_LITTLE)) {
            return 10;
        }
        if (input.equals(RIGHT_SLAP)) {
            return 13;
        }
        if (input.equals(LEFT_SLAP)) {
            return 14;
        }
        if (input.equals(THUMBS)) {
            return 15;
        }
        if (input.startsWith("right")) {
            return 13;
        }
        if (input.startsWith("left")) {
            return 14;
        }
        return 0;
    }

    public static int decodePosition(String input, int hand_cd) {
        if (hand_cd == 1) {
            if (input.equals(THUMB)) {
                return 1;
            }
            if (input.equals(INDEX)) {
                return 2;
            }
            if (input.equals(MIDDLE)) {
                return 3;
            }
            if (input.equals(RING)) {
                return 4;
            }
            if (input.equals(LITTLE)) {
                return 5;
            }
            return 0;
        }
        if (hand_cd == 2) {
            if (input.equals(THUMB)) {
                return 6;
            }
            if (input.equals(INDEX)) {
                return 7;
            }
            if (input.equals(MIDDLE)) {
                return 8;
            }
            if (input.equals(RING)) {
                return 9;
            }
            if (input.equals(LITTLE)) {
                return 10;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int compareTo(Object input) {
        int you_idx;
        int supcomp = super.compareTo(input);
        if (supcomp != 0) {
            return supcomp;
        }
        String tmp_sub = ((CBEFFFinger)input).getSubType();
        String tmp_cap = ((CBEFFFinger)input).getCaptureDate();
        if (this._subtype.equals(tmp_sub)) {
            return this._captureDate.compareTo(tmp_cap);
        }
        int me_idx = this._subtypes.indexOf(this._subtype);
        if (me_idx < (you_idx = this._subtypes.indexOf(tmp_sub))) {
            return -1;
        }
        return 1;
    }

    public String getBranchName() {
        return "bir";
    }

    public Branch getGPBranch() {
        Branch img_bir = new Branch();
        Branch img_bir_info = new Branch();
        img_bir_info.setAttribute("integrity", "false");
        img_bir_info.setAttribute("creation-date", this.getCaptureDate());
        img_bir_info.setAttribute("attempt", "" + this.getAttempt());
        img_bir.addBranch("bir-info", img_bir_info);
        Branch img_bdb_info = new Branch();
        img_bdb_info.setAttribute("format-owner", "257");
        img_bdb_info.setAttribute("format-type", "7");
        img_bdb_info.setAttribute("encryption", "false");
        img_bdb_info.setAttribute("creation-date", this.getCaptureDate());
        img_bdb_info.setAttribute("subtype", this.getSubType());
        img_bdb_info.setAttribute("quality", this.getQuality());
        img_bdb_info.setAttribute("quality-alg-owner", this.getQualityAlgOwner());
        img_bdb_info.setAttribute("quality-alg-type", this.getQualityAlgType());
        img_bdb_info.setAttribute("manual-segmentation", "" + this.getManualSegmentation());
        if (this._segments != null && this._segments.size() > 0) {
            for (CBEFFFingerSegment tmp_seg : this._segments) {
                img_bdb_info.addBranch(tmp_seg.getBranchName(), tmp_seg.getGPBranch());
            }
        }
        img_bir.addBranch("bdb-info", img_bdb_info);
        img_bir.setInfo("bdb", new String(this.getImageISOBase64()));
        return img_bir;
    }

    public String toCBEFFString() {
        return this.toCBEFFString("");
    }

    public String toCBEFFString(String line_pre) {
        String output = new String("");
        output = output + line_pre + "<bir>\n";
        output = output + line_pre + "\t<bir-info integrity=\"false\" creation-date=\"" + this.getCaptureDate() + "\" ";
        output = output + "attempt=\"" + this.getAttempt() + "\" />\n";
        output = output + line_pre + "\t<bdb-info format-owner=\"257\" format-type=\"7\" encryption=\"false\" ";
        output = output + "creation-date=\"" + this.getCaptureDate() + "\" subtype=\"" + this.getSubType() + "\" quality=\"" + this.getQuality();
        output = output + "\" quality-alg-owner=\"" + this.getQualityAlgOwner() + "\" quality-alg-type=\"" + this.getQualityAlgType();
        output = output + "\" manual-segmentation=\"" + this.getManualSegmentation() + "\" />\n";
        if (this._segments != null && this._segments.size() > 0) {
            for (CBEFFFingerSegment tmp_seg : this._segments) {
                output = output + tmp_seg.toCBEFFString(line_pre + "\t");
            }
        }
        output = output + line_pre + "\t<bdb>" + new String(this.getImageISOBase64()) + "</bdb>\n";
        output = output + line_pre + "</bir>\n";
        return output;
    }
}

