/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import net.damango.pub.genparser.Branch;
import org.apache.log4j.Logger;

public class CBEFFFingerSegment {
    private final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    public static final String RIGHT_THUMB = new String("right thumb");
    public static final String RIGHT_INDEX = new String("right pointer-finger");
    public static final String RIGHT_RING = new String("right ring-finger");
    public static final String RIGHT_MIDDLE = new String("right middle-finger");
    public static final String RIGHT_LITTLE = new String("right little-finger");
    public static final String LEFT_THUMB = new String("left thumb");
    public static final String LEFT_INDEX = new String("left pointer-finger");
    public static final String LEFT_MIDDLE = new String("left middle-finger");
    public static final String LEFT_RING = new String("left ring-finger");
    public static final String LEFT_LITTLE = new String("left little-finger");
    private String _finger_position = null;
    private String _xCentre = "0";
    private String _yCentre = "0";
    private String _width = "0";
    private String _height = "0";
    private String _angle = "0.0";
    private String _orientation = "ORIENTED";
    private String _seg_confidence = "0";
    private String _quality = "0";
    private String _quality_alg_owner = "0";
    private String _quality_alg_type = "0";

    public CBEFFFingerSegment() {
    }

    public CBEFFFingerSegment(String finger_position, String xCentre, String yCentre, String width, String height, String angle, String orientation, String seg_confidence, String quality, String quality_alg_owner, String quality_alg_type) {
        this.setFingerPosition(finger_position);
        this.setXCentre(xCentre);
        this.setYCentre(yCentre);
        this.setWidth(width);
        this.setHeight(height);
        this.setAngle(angle);
        this.setOrientation(orientation);
        this.setSegConfidence(seg_confidence);
        this.setQuality(quality);
        this.setQualityAlgOwner(quality_alg_owner);
        this.setQualityAlgType(quality_alg_type);
    }

    public String getFingerPosition() {
        return this._finger_position;
    }

    public String getXCentre() {
        return this._xCentre;
    }

    public String getYCentre() {
        return this._yCentre;
    }

    public String getWidth() {
        return this._width;
    }

    public String getHeight() {
        return this._height;
    }

    public String getAngle() {
        return this._angle;
    }

    public String getOrientation() {
        return this._orientation;
    }

    public String getSegConfidence() {
        return this._seg_confidence;
    }

    public String getQuality() {
        return this._quality;
    }

    public String getQualityAlgOwner() {
        return this._quality_alg_owner;
    }

    public String getQualityAlgType() {
        return this._quality_alg_type;
    }

    public void setFingerPosition(String input) {
        this._finger_position = input != null && !input.equals("") ? new String(input) : null;
    }

    public void setXCentre(String input) {
        this._xCentre = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setYCentre(String input) {
        this._yCentre = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setWidth(String input) {
        this._width = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setHeight(String input) {
        this._height = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setAngle(String input) {
        this._angle = input != null && !input.equals("") ? new String(input) : new String("0.0");
    }

    public void setOrientation(String input) {
        this._orientation = input != null && !input.equals("") ? new String(input) : new String("ORIENTED");
    }

    public void setSegConfidence(String input) {
        this._seg_confidence = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setQuality(String input) {
        this._quality = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setQualityAlgOwner(String input) {
        this._quality_alg_owner = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public void setQualityAlgType(String input) {
        this._quality_alg_type = input != null && !input.equals("") ? new String(input) : new String("0");
    }

    public String getBranchName() {
        return "segment";
    }

    public Branch getGPBranch() {
        Branch output = new Branch();
        output.setInfo("position", this._finger_position);
        Branch box = new Branch();
        box.setInfo("xCentre", this._xCentre);
        box.setInfo("yCentre", this._yCentre);
        box.setInfo("width", this._width);
        box.setInfo("height", this._height);
        box.setInfo("angle", this._angle);
        box.setInfo("orientation", this._orientation);
        output.addBranch("box", box);
        output.setInfo("seg-confidence", this._seg_confidence);
        output.setInfo("quality", this._quality);
        output.setInfo("quality-alg-owner", this._quality_alg_owner);
        output.setInfo("quality-alg-type", this._quality_alg_type);
        return output;
    }

    public String toCBEFFString() {
        return this.toCBEFFString("");
    }

    public String toCBEFFString(String line_pre) {
        String output = new String("");
        output = output + line_pre + "<segment>\n";
        output = output + line_pre + "\t<position>" + this._finger_position + "</position>\n";
        output = output + line_pre + "\t<box>\n";
        output = output + line_pre + "\t\t<xCentre>" + this._xCentre + "</xCentre>\n";
        output = output + line_pre + "\t\t<yCentre>" + this._yCentre + "</yCentre>\n";
        output = output + line_pre + "\t\t<width>" + this._width + "</width>\n";
        output = output + line_pre + "\t\t<height>" + this._height + "</height>\n";
        output = output + line_pre + "\t\t<angle>" + this._angle + "</angle>\n";
        output = output + line_pre + "\t\t<orientation>" + this._orientation + "</orientation>\n";
        output = output + line_pre + "\t</box>\n";
        output = output + line_pre + "\t<seg-confidence>" + this._seg_confidence + "</seg-confidence>\n";
        output = output + line_pre + "\t<quality>" + this._quality + "</quality>\n";
        output = output + line_pre + "\t<quality-alg-owner>" + this._quality_alg_owner + "</quality-alg-owner>\n";
        output = output + line_pre + "\t<quality-alg-type>" + this._quality_alg_type + "</quality-alg-type>\n";
        output = output + line_pre + "</segment>\n";
        return output;
    }

    public String toString() {
        String output = new String("");
        output = output + "SEG:(" + this._finger_position + "-X:" + this._xCentre + "-Y:" + this._yCentre;
        output = output + "-W:" + this._width + "-H:" + this._height + "-A:" + this._angle + "-Q" + this._quality + ")";
        return output;
    }
}

