/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFBiometric;
import com.identix.uidai.cbeff.IrisISO;
import net.damango.pub.genparser.Branch;
import org.apache.log4j.Logger;

public class CBEFFIris
extends CBEFFBiometric
implements Comparable {
    public static final String UNDEF = new String("");
    public static final String RIGHT = new String("right");
    public static final String LEFT = new String("left");
    public static final int RAW_MONO = 2;
    public static final int RAW = 4;
    public static final int JPEG_MONO = 6;
    public static final int JPEG = 8;
    public static final int JPEG_LS_MONO = 10;
    public static final int JPEG_LS = 12;
    public static final int JPEG_2000_MONO = 14;
    public static final int JPEG_2000 = 16;
    protected final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    protected int _horizontal_orientation = 1;
    protected int _vertical_orientation = 1;
    protected int _scan_type = 0;
    protected int _occlusions = 0;
    protected int _occlusion_filling = 0;
    protected int _boundary_extraction = 0;

    public CBEFFIris() {
        this.setType(IRIS);
    }

    public CBEFFIris(String subtype, byte[] image) {
        this.setType(IRIS);
        this.setSubType(subtype);
        this.setImage(image);
    }

    public int getHorizontalOrientation() {
        return this._horizontal_orientation;
    }

    public int getVerticalOrientation() {
        return this._vertical_orientation;
    }

    public int getScanType() {
        return this._scan_type;
    }

    public int getOcclusions() {
        return this._occlusions;
    }

    public int getOcclusionFilling() {
        return this._occlusion_filling;
    }

    public int getBoundaryExtraction() {
        return this._boundary_extraction;
    }

    public void setHorizontalOrientation(int input) {
        this._horizontal_orientation = input;
    }

    public void setVerticalOrientation(int input) {
        this._vertical_orientation = input;
    }

    public void setScanType(int input) {
        this._scan_type = input;
    }

    public void setOcclusions(int input) {
        this._occlusions = input;
    }

    public void setOcclusionFilling(int input) {
        this._occlusion_filling = input;
    }

    public void setBoundaryExtraction(int input) {
        this._boundary_extraction = input;
    }

    public byte[] packageImage(byte[] input) {
        this.LOG.info((Object)("Packaging Iris with file type: " + this.getFileType() + " SubType: " + this.getSubType()));
        byte[] output = IrisISO.packageImage(input, this.getFileType(), CBEFFIris.decodePosition(this.getSubType()), 0, 0);
        return output;
    }

    public static int decodeFileType(int input) {
        switch (input) {
            case 2: {
                return 6;
            }
            case 4: {
                return 10;
            }
            case 8: 
            case 10: {
                return 2;
            }
        }
        return 14;
    }

    public static int encodeFileType(int input) {
        switch (input) {
            case 8: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 4: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 16: {
                return 0;
            }
        }
        return 1;
    }

    public String translateImageType(int input) {
        switch (input) {
            case 2: 
            case 4: {
                return "raw";
            }
            case 6: 
            case 8: {
                return "jpg";
            }
            case 10: 
            case 12: {
                return "jls";
            }
        }
        return "jp2";
    }

    public static int decodePosition(String input) {
        if (input.equals(RIGHT)) {
            return 1;
        }
        if (input.equals(LEFT)) {
            return 2;
        }
        return 0;
    }

    public static String decodePosition(int input) {
        switch (input) {
            case 1: {
                return "right";
            }
            case 2: {
                return "left";
            }
        }
        return "";
    }

    public int compareTo(Object input) {
        int supcomp = super.compareTo(input);
        if (supcomp != 0) {
            return supcomp;
        }
        String tmp_sub = ((CBEFFIris)input).getSubType();
        String tmp_cap = ((CBEFFIris)input).getCaptureDate();
        if (this._subtype.equals(tmp_sub)) {
            return this._captureDate.compareTo(tmp_cap);
        }
        if (this._subtype.equals(LEFT)) {
            return -1;
        }
        return 1;
    }

    public String getBranchName() {
        return "bir";
    }

    public Branch getGPBranch() {
        Branch img_bir = new Branch();
        Branch img_bir_info = new Branch();
        img_bir_info.setAttribute("integrity", "false");
        img_bir_info.setAttribute("creation-date", this.getCaptureDate());
        img_bir_info.setAttribute("attempt", "" + this.getAttempt());
        img_bir.addBranch("bir-info", img_bir_info);
        Branch img_bdb_info = new Branch();
        img_bdb_info.setAttribute("format-owner", "257");
        img_bdb_info.setAttribute("format-type", "9");
        img_bdb_info.setAttribute("encryption", "false");
        img_bdb_info.setAttribute("creation-date", this.getCaptureDate());
        img_bdb_info.setAttribute("subtype", this.getSubType());
        img_bdb_info.setAttribute("quality", this.getQuality());
        img_bdb_info.setAttribute("quality-alg-owner", this.getQualityAlgOwner());
        img_bdb_info.setAttribute("quality-alg-type", this.getQualityAlgType());
        img_bdb_info.setAttribute("manual-segmentation", "" + this.getManualSegmentation());
        img_bir.addBranch("bdb-info", img_bdb_info);
        img_bir.setInfo("bdb", new String(this.getImageISOBase64()));
        return img_bir;
    }

    public String toCBEFFString() {
        return this.toCBEFFString("");
    }

    public String toCBEFFString(String line_pre) {
        String output = new String("");
        output = output + line_pre + "<bir>\n";
        output = output + line_pre + "\t<bir-info integrity=\"false\" creation-date=\"" + this.getCaptureDate() + "\" ";
        output = output + "attempt=\"" + this.getAttempt() + "\" />\n";
        output = output + line_pre + "\t<bdb-info format-owner=\"257\" format-type=\"9\" encryption=\"false\" ";
        output = output + "creation-date=\"" + this.getCaptureDate() + "\" subtype=\"" + this.getSubType() + "\" quality=\"" + this.getQuality();
        output = output + "\" quality-alg-owner=\"" + this.getQualityAlgOwner() + "\" quality-alg-type=\"" + this.getQualityAlgType();
        output = output + "\" manual-segmentation=\"" + this.getManualSegmentation() + "\" />\n";
        output = output + line_pre + "\t<bdb>" + new String(this.getImageISOBase64()) + "</bdb>\n";
        output = output + line_pre + "</bir>\n";
        return output;
    }
}

