/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFF;
import com.identix.uidai.cbeff.CBEFFFace;
import com.identix.uidai.cbeff.CBEFFFinger;
import com.identix.uidai.cbeff.CBEFFIris;
import com.identix.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CatalogCBEFF {
    public static void main(String[] args) {
        Logger LOG_OUT = Logger.getLogger((String)"output");
        Logger LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.CatalogCBEFF.class");
        if (args.length < 1) {
            LOG.info((Object)"Invalid Arguments: Must specify a CBEFF file to parse or -l to read list of files from STDIN!");
            System.exit(-1);
        } else if (args[0].equalsIgnoreCase("-l")) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String fname = null;
                File input = null;
                fname = stdin.readLine();
                while (fname != null) {
                    block21: {
                        String log_info = new String(",File: \"" + fname + "\",");
                        byte[] cbeff_file_data = null;
                        try {
                            LOG.info((Object)("Attempting to read file \"" + fname + "\" at " + new Date().getTime()));
                            input = new File(fname);
                            LOG.info((Object)("'Real' file name \"" + input.getAbsolutePath() + "\""));
                            cbeff_file_data = Utility.getImageByteArray(input);
                            LOG.info((Object)("Length of data: " + cbeff_file_data.length));
                            LOG.info((Object)("File read by " + new Date().getTime()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Reading CBEFF file failed!", (Throwable)e);
                            LOG_OUT.error((Object)(log_info + "FAILED_TO_READ"));
                            break block21;
                        }
                        try {
                            LOG.info((Object)("Attempting to parse read data at " + new Date().getTime()));
                            CBEFF my_cbeff = new CBEFF(cbeff_file_data, true, false, false);
                            LOG.info((Object)("Completed parsing read data at " + new Date().getTime()));
                            Vector<CBEFFFace> faces = my_cbeff.getFaces();
                            for (int i = 0; i < faces.size(); ++i) {
                                CBEFFFace tmp_image = faces.elementAt(i);
                                String subtype = tmp_image.getSubType();
                                log_info = log_info + "FACE#(" + (i + 1) + ")-type(" + subtype + "),";
                            }
                            Vector<CBEFFIris> irisses = my_cbeff.getIrisses();
                            for (int i = 0; i < irisses.size(); ++i) {
                                CBEFFIris tmp_image = irisses.elementAt(i);
                                String subtype = tmp_image.getSubType();
                                int hflip = tmp_image.getHorizontalOrientation();
                                int vflip = tmp_image.getVerticalOrientation();
                                log_info = log_info + "IRIS#(" + (i + 1) + ")-type(" + subtype + ")-hflip(" + hflip + ")-vflip(" + vflip + "),";
                            }
                            Vector<CBEFFFinger> fingers = my_cbeff.getFingers();
                            for (int i = 0; i < fingers.size(); ++i) {
                                CBEFFFinger tmp_image = fingers.elementAt(i);
                                String subtype = tmp_image.getSubType();
                                String slap_sub = tmp_image.getSlapSubType();
                                log_info = log_info + "FINGER#(" + (i + 1) + ")-ISOtype(" + subtype + ")-CBEFFtype(" + slap_sub + "),";
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Extracting images failed!", (Throwable)e);
                            LOG_OUT.error((Object)(log_info + "FAILED_TO_PARSE"));
                            break block21;
                        }
                        LOG_OUT.info((Object)log_info);
                    }
                    fname = stdin.readLine();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cataloging CBEFFs failed!", (Throwable)e);
                System.exit(-4);
            }
        } else {
            byte[] cbeff_file_data = null;
            File input = null;
            String log_info = new String(",File: \"" + args[0] + "\",");
            try {
                input = new File(args[0]);
                cbeff_file_data = Utility.getImageByteArray(input);
                LOG.info((Object)("Length of data: " + cbeff_file_data.length));
            }
            catch (Exception e) {
                LOG.error((Object)"Reading CBEFF file failed!", (Throwable)e);
                LOG_OUT.error((Object)(log_info + "FAILED_TO_READ"));
                System.exit(-2);
            }
            try {
                CBEFF my_cbeff = new CBEFF(cbeff_file_data, true, false, false);
                Vector<CBEFFFace> faces = my_cbeff.getFaces();
                for (int i = 0; i < faces.size(); ++i) {
                    CBEFFFace tmp_image = faces.elementAt(i);
                    String subtype = tmp_image.getSubType();
                    log_info = log_info + "FACE#(" + (i + 1) + ")-type(" + subtype + "),";
                }
                Vector<CBEFFIris> irisses = my_cbeff.getIrisses();
                for (int i = 0; i < irisses.size(); ++i) {
                    CBEFFIris tmp_image = irisses.elementAt(i);
                    String subtype = tmp_image.getSubType();
                    log_info = log_info + "IRIS#(" + (i + 1) + ")-type(" + subtype + "),";
                }
                Vector<CBEFFFinger> fingers = my_cbeff.getFingers();
                for (int i = 0; i < fingers.size(); ++i) {
                    CBEFFFinger tmp_image = fingers.elementAt(i);
                    String slap_sub = tmp_image.getSlapSubType();
                    log_info = log_info + "FINGER#(" + (i + 1) + ")-type(" + slap_sub + "),";
                }
                LOG_OUT.info((Object)log_info);
            }
            catch (Exception e) {
                LOG.error((Object)"Extracting images failed!", (Throwable)e);
                LOG_OUT.error((Object)(log_info + "FAILED_TO_PARSE"));
                System.exit(-4);
            }
        }
    }
}

