/*
 * Decompiled with CFR 0.152.
 */
package com.identix.uidai.cbeff;

import com.identix.uidai.cbeff.CBEFFBiometric;
import com.identix.uidai.cbeff.CBEFFFingerSegment;
import com.identix.uidai.cbeff.CBEFFISOFace;
import com.identix.uidai.cbeff.CBEFFISOFinger;
import com.identix.uidai.cbeff.CBEFFISOIris;
import com.identix.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;
import net.damango.pub.genparser.Branch;
import net.damango.pub.genparser.DocumentHolder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractCBEFFISO {
    public static final String _cbeff_version = "2";
    private String _createDate = new String("20101216T162000Z");
    private String _integrity = new String("false");
    private Vector<CBEFFISOFace> _faces = new Vector();
    private Vector<CBEFFISOFinger> _fingers = new Vector();
    private Vector<CBEFFISOIris> _irisses = new Vector();
    private final Logger LOG = Logger.getLogger((String)this.getClass().getName());
    private static final Logger STATIC_LOG = Logger.getLogger((String)"com.identix.uidai.cbeff.ExtractCBEFFISO.class");

    public ExtractCBEFFISO(byte[] input) {
        this.parseCBEFFFileGP(input);
    }

    public Vector<CBEFFISOFace> getFaces() {
        return this._faces;
    }

    public Vector<CBEFFISOFinger> getFingers() {
        return this._fingers;
    }

    public Vector<CBEFFISOIris> getIrisses() {
        return this._irisses;
    }

    public String getIntegrity() {
        return this._integrity;
    }

    public Date getCreateDate() {
        return Utility.parseDate(this._createDate);
    }

    public void addFace(CBEFFISOFace input) {
        this._faces.addElement(input);
    }

    public void addFinger(CBEFFISOFinger input) {
        this._fingers.addElement(input);
    }

    public void addIris(CBEFFISOIris input) {
        this._irisses.addElement(input);
    }

    public void setIntegrity(String input) {
        this._integrity = new String(input);
    }

    public void setCreationDate(String input) {
        this._createDate = new String(input);
    }

    private boolean parseCBEFFFileGP(byte[] input) {
        try {
            DocumentHolder doc = new DocumentHolder();
            doc.parseXML(input);
            Branch main_info = doc.getBranch("bir-info");
            if (main_info != null) {
                String integrity = main_info.getAttribute("integrity");
                String creator = main_info.getAttribute("creation-date");
                this.setIntegrity(integrity);
                this.setCreationDate(creator);
            } else {
                this.LOG.info((Object)"No main info!");
            }
            Branch[] main_birs = doc.getBranches("bir");
            if (main_birs != null && main_birs.length < 1) {
                this.LOG.info((Object)"No BIRs returned from the parser!");
            } else {
                for (int i = 0; i < main_birs.length; ++i) {
                    byte[] byte_image;
                    String bio_image;
                    String man_seg;
                    String qual_alg_type;
                    String qual_alg_own;
                    String qual;
                    String subtype;
                    String creationdate;
                    Branch sub_bio_info;
                    String tmp_attempt;
                    Branch sub_bir_info;
                    Branch tmp_sb_bir;
                    int j;
                    Branch[] sub_birs;
                    Branch tmp_mn_bir = main_birs[i];
                    Branch bio_info = tmp_mn_bir.getBranch("bdb-info");
                    String type = null;
                    if (bio_info != null) {
                        type = bio_info.getAttribute("type");
                    } else {
                        this.LOG.info((Object)"No biometric info!");
                    }
                    if (type != null && type.equalsIgnoreCase("face")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No faces included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No facial sub-biometric info!");
                            }
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            CBEFFISOFace new_face = new CBEFFISOFace();
                            new_face.setAttempt(tmp_attempt);
                            new_face.setQuality(qual);
                            new_face.setQualityAlgOwner(qual_alg_own);
                            new_face.setQualityAlgType(qual_alg_type);
                            new_face.setManualSegmentation(man_seg);
                            new_face.setImage(byte_image);
                            new_face.setType(CBEFFBiometric.FACE);
                            new_face.setCaptureDate(creationdate);
                            this.addFace(new_face);
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("iris")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No Irisses included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No iris sub-biometric info!");
                            }
                            bio_image = tmp_sb_bir.getInfo("bdb");
                            byte_image = Utility.convertFromBase64(bio_image);
                            CBEFFISOIris new_iris = new CBEFFISOIris();
                            new_iris.setAttempt(tmp_attempt);
                            new_iris.setQuality(qual);
                            new_iris.setQualityAlgOwner(qual_alg_own);
                            new_iris.setQualityAlgType(qual_alg_type);
                            new_iris.setManualSegmentation(man_seg);
                            new_iris.setImage(byte_image);
                            new_iris.setType(CBEFFBiometric.IRIS);
                            new_iris.setSubType(subtype);
                            new_iris.setCaptureDate(creationdate);
                            this.addIris(new_iris);
                        }
                        continue;
                    }
                    if (type != null && type.equalsIgnoreCase("finger")) {
                        sub_birs = tmp_mn_bir.getBranches("bir");
                        if (sub_birs.length < 1) {
                            this.LOG.info((Object)"No fingers included in BIR!");
                            continue;
                        }
                        for (j = 0; j < sub_birs.length; ++j) {
                            tmp_sb_bir = sub_birs[j];
                            sub_bir_info = tmp_sb_bir.getBranch("bir-info");
                            tmp_attempt = null;
                            if (sub_bir_info != null) {
                                tmp_attempt = sub_bir_info.getAttribute("attempt");
                            }
                            sub_bio_info = tmp_sb_bir.getBranch("bdb-info");
                            creationdate = null;
                            subtype = null;
                            qual = null;
                            qual_alg_own = null;
                            qual_alg_type = null;
                            man_seg = null;
                            if (sub_bio_info != null) {
                                creationdate = sub_bio_info.getAttribute("creation-date");
                                subtype = sub_bio_info.getAttribute("subtype");
                                qual = sub_bio_info.getAttribute("quality");
                                qual_alg_own = sub_bio_info.getAttribute("quality-alg-owner");
                                qual_alg_type = sub_bio_info.getAttribute("quality-alg-type");
                                man_seg = sub_bio_info.getAttribute("manual-segmentation");
                            } else {
                                this.LOG.info((Object)"No finger sub-biometric info!");
                            }
                            Vector<CBEFFFingerSegment> tmp_segs = new Vector<CBEFFFingerSegment>();
                            Branch[] segs = sub_bio_info.getBranches("segment");
                            if (segs.length < 1) {
                                this.LOG.info((Object)"No segments included with finger image.");
                            } else {
                                for (int k = 0; k < segs.length; ++k) {
                                    CBEFFFingerSegment tmp_seg = new CBEFFFingerSegment();
                                    tmp_seg.setFingerPosition(segs[k].getInfo("position"));
                                    tmp_seg.setSegConfidence(segs[k].getInfo("seg-confidence"));
                                    tmp_seg.setQuality(segs[k].getInfo("quality"));
                                    tmp_seg.setQualityAlgOwner(segs[k].getInfo("quality-alg-owner"));
                                    tmp_seg.setQualityAlgType(segs[k].getInfo("quality-alg-type"));
                                    Branch tmp_box = segs[k].getBranch("box");
                                    if (tmp_box != null) {
                                        tmp_seg.setXCentre(tmp_box.getInfo("xCentre"));
                                        tmp_seg.setYCentre(tmp_box.getInfo("yCentre"));
                                        tmp_seg.setWidth(tmp_box.getInfo("width"));
                                        tmp_seg.setHeight(tmp_box.getInfo("height"));
                                        tmp_seg.setAngle(tmp_box.getInfo("angle"));
                                        tmp_seg.setOrientation(tmp_box.getInfo("orientation"));
                                    }
                                    tmp_segs.add(tmp_seg);
                                }
                            }
                            String bio_image2 = tmp_sb_bir.getInfo("bdb");
                            byte[] byte_image2 = Utility.convertFromBase64(bio_image2);
                            CBEFFISOFinger new_finger = new CBEFFISOFinger();
                            new_finger.setAttempt(tmp_attempt);
                            new_finger.setQuality(qual);
                            new_finger.setQualityAlgOwner(qual_alg_own);
                            new_finger.setQualityAlgType(qual_alg_type);
                            new_finger.setManualSegmentation(man_seg);
                            new_finger.addSegments(tmp_segs);
                            new_finger.setImage(byte_image2);
                            new_finger.setType(CBEFFBiometric.FINGER);
                            new_finger.setSubType(subtype);
                            new_finger.setSlapSubtype(subtype);
                            new_finger.setCaptureDate(creationdate);
                            this.addFinger(new_finger);
                        }
                        continue;
                    }
                    if (type == null) {
                        this.LOG.error((Object)"Can't parse unspecified biometric type");
                        continue;
                    }
                    this.LOG.error((Object)("Unsupported biometric type: " + type));
                }
            }
            return true;
        }
        catch (Exception e) {
            this.LOG.error((Object)"CBEFF File failed to parse!", (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Invalid Arguments: Must specify a CBEFF file to parse or -l to read list of files from STDIN!");
            System.exit(-1);
        } else if (args[0].equalsIgnoreCase("-l")) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String fname = null;
                File input = null;
                fname = stdin.readLine();
                while (fname != null) {
                    byte[] cbeff_file_data = null;
                    try {
                        System.out.println("Attempting to read file \"" + fname + "\" at " + new Date().getTime());
                        input = new File(fname);
                        System.out.println("'Real' file name \"" + input.getAbsolutePath() + "\"");
                        cbeff_file_data = Utility.getImageByteArray(input);
                        System.out.println("Length of data: " + cbeff_file_data.length);
                        System.out.println("File read by " + new Date().getTime());
                    }
                    catch (Exception e) {
                        System.out.println("Reading CBEFF file failed!");
                        e.printStackTrace();
                        System.exit(-2);
                    }
                    String out_folder = new String("output" + File.separator + input.getName().replace(".xml", ""));
                    try {
                        new File(out_folder).mkdirs();
                        System.out.println("Attempting to parse read data at " + new Date().getTime());
                        ExtractCBEFFISO my_cbeff = new ExtractCBEFFISO(cbeff_file_data);
                        System.out.println("Completed parsing read data at " + new Date().getTime());
                        Vector<CBEFFISOFace> faces = my_cbeff.getFaces();
                        for (int i = 0; i < faces.size(); ++i) {
                            CBEFFISOFace tmp_image = faces.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                System.out.println("Writing parsed facial image failed!");
                                e.printStackTrace();
                                System.exit(-3);
                            }
                        }
                        Vector<CBEFFISOIris> irisses = my_cbeff.getIrisses();
                        for (int i = 0; i < irisses.size(); ++i) {
                            CBEFFISOIris tmp_image = irisses.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                System.out.println("Writing parsed finger image failed!");
                                e.printStackTrace();
                                System.exit(-3);
                            }
                        }
                        Vector<CBEFFISOFinger> fingers = my_cbeff.getFingers();
                        for (int i = 0; i < fingers.size(); ++i) {
                            CBEFFISOFinger tmp_image = fingers.elementAt(i);
                            byte[] tmp_img = tmp_image.getImage();
                            int img_type = tmp_image.getFileType();
                            String type = tmp_image.getType();
                            String subtype = tmp_image.getSubType();
                            String slap_sub = tmp_image.getSlapSubType();
                            Vector<Integer> missing = tmp_image.getMissingFingers();
                            Vector<CBEFFFingerSegment> segments = tmp_image.getSegments();
                            System.out.println("Finger SUBTYPE=\"" + subtype + "\" SLAP_TYPE=\"" + slap_sub + "\" MISSING=\"" + missing.toString() + "\" SEGMENTS=\"" + segments.toString());
                            try {
                                Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + slap_sub + "." + tmp_image.translateImageType(img_type));
                                continue;
                            }
                            catch (Exception e) {
                                System.out.println("Writing parsed finger image failed!");
                                e.printStackTrace();
                                System.exit(-3);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Extracting images failed!");
                        e.printStackTrace();
                        System.exit(-4);
                    }
                    fname = stdin.readLine();
                }
            }
            catch (Exception e) {
                System.out.println("Extracting images failed!");
                e.printStackTrace();
                System.exit(-4);
            }
        } else {
            byte[] cbeff_file_data = null;
            File input = null;
            try {
                input = new File(args[0]);
                cbeff_file_data = Utility.getImageByteArray(input);
                System.out.println("Length of data: " + cbeff_file_data.length);
            }
            catch (Exception e) {
                System.out.println("Reading CBEFF file failed!");
                e.printStackTrace();
                System.exit(-2);
            }
            String out_folder = new String("output" + File.separator + input.getName().replace(".xml", ""));
            try {
                new File(out_folder).mkdirs();
                ExtractCBEFFISO my_cbeff = new ExtractCBEFFISO(cbeff_file_data);
                Vector<CBEFFISOFace> faces = my_cbeff.getFaces();
                for (int i = 0; i < faces.size(); ++i) {
                    CBEFFISOFace tmp_image = faces.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Writing parsed facial image failed!");
                        e.printStackTrace();
                        System.exit(-3);
                    }
                }
                Vector<CBEFFISOIris> irisses = my_cbeff.getIrisses();
                for (int i = 0; i < irisses.size(); ++i) {
                    CBEFFISOIris tmp_image = irisses.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + subtype + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Writing parsed finger image failed!");
                        e.printStackTrace();
                        System.exit(-3);
                    }
                }
                Vector<CBEFFISOFinger> fingers = my_cbeff.getFingers();
                for (int i = 0; i < fingers.size(); ++i) {
                    CBEFFISOFinger tmp_image = fingers.elementAt(i);
                    byte[] tmp_img = tmp_image.getImage();
                    int img_type = tmp_image.getFileType();
                    String type = tmp_image.getType();
                    String subtype = tmp_image.getSubType();
                    String slap_sub = tmp_image.getSlapSubType();
                    Vector<Integer> missing = tmp_image.getMissingFingers();
                    Vector<CBEFFFingerSegment> segments = tmp_image.getSegments();
                    System.out.println("Finger SUBTYPE=\"" + subtype + "\" SLAP_TYPE=\"" + slap_sub + "\" MISSING=\"" + missing.toString() + "\" SEGMENTS=\"" + segments.toString());
                    try {
                        Utility.writeBytesToFile(tmp_img, out_folder, input.getName() + "." + (i + 1) + "." + type + "." + slap_sub + "." + tmp_image.translateImageType(img_type));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Writing parsed finger image failed!");
                        e.printStackTrace();
                        System.exit(-3);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Extracting images failed!");
                e.printStackTrace();
                System.exit(-4);
            }
        }
    }
}

